#!/bin/bash

# yglfs_functions.sh
# created by Yann Guidon <whygee@f-cpu.org> april, 10th 2002
# this script contains some common functions for the different
# YGLFS scripts, such as the colors and message handling stuff.

# version : initial

# some cut&paste from /etc/init.d/functions
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"

export YGLFS_LOG=/dev/null

function message_ok () {
  echo "OK: " $* >> $YGLFS_LOG
  echo -n " [ "
  $SETCOLOR_SUCCESS
  echo -n $*
  $SETCOLOR_NORMAL
  echo " ]"
}

function message_ko () {
  echo "KO: $* ==> aborting" >> $YGLFS_LOG
  echo -n " [ "
  $SETCOLOR_FAILURE
  echo -n "$* ==> aborting"
  $SETCOLOR_NORMAL
  echo " ]"
  date
  exit -1
}

function message_warning () {
  echo "  : $*" >> $YGLFS_LOG
  if [ "$YGLFS_NOWARNING" == "" ]
  then
    echo -n " [ "
    $SETCOLOR_WARNING
    echo -n $*
    $SETCOLOR_NORMAL
    echo " ]"
  fi
}

function message_debug () {
  if [ -n "$DEBUG_YGLFS" ]
  then
    echo $*
    echo $* >> $YGLFS_LOG
  fi
}
