#!/bin/bash

# otherapps.sh
# created by whygee@f-cpu.org may 5th, 2002
# this script installs the additional packages that are necessary beyond
# the bare (YG)LFS system. Mainly chosen pieces from the BLFS book and
# whygee stuff.

if [ ! -d /usr/yglfs ]
then
  echo "error : YGLFS is not installed"
  exit -1
fi

YGLFS=/usr/yglfs
cd $YGLFS
source message_functions.sh
YGLFS_LOGDIR=$YGLFS/log
if [ ! -d "$YGLFS_LOGDIR" ]
then
  mkdir -v -p $YGLFS_LOGDIR
fi
YGLFS_LOG=$YGLFS_LOGDIR/.yglfs_log.3
LFS=/

if [ ! -e /etc/issue ]
then
  clear > /etc/issue &&
  echo >> /etc/issue && 
  $SETCOLOR_SUCCESS >> /etc/issue &&
  echo "       Welcome to \n" >> /etc/issue &&
  $SETCOLOR_WARNING >> /etc/issue &&
  echo " \t - \d, \U" >> /etc/issue &&
  $SETCOLOR_NORMAL >> /etc/issue &&
  echo >> /etc/issue &&
  echo >> /etc/issue &&
  message_ok "/etc/issue created"
fi

if [ ! -e /etc/inputrc ]
then
  cat > /etc/inputrc << "EOF"
# ---- Begin  /etc/inputrc

# Make sure we dont output everything on the 1 line
set horizontal-scroll-mode Off

# Enables 8 bit input
set meta-flag On
# Enables 8 bit input
set input-meta On
# Turns off 8th bit stripping
set convert-meta Off
# Keep the 8th bit for display
set output-meta On
# none,visable or audible
set bell-style none

# All of the following map the escape sequence of the
# value contained inside the 1st argument to the
# readline specific functions

"\eOd": backward-word
"\eOc": forward-word

# for linux console
"\e[1~": beginning-of-line
"\e[2~": quoted-insert
"\e[3~": delete-char
"\e[4~": end-of-line
#"\e[5~": beginning-of-history
#"\e[6~": end-of-history

# home key
#"\e[1~":beginning-of-line
# insert key
#"\e[2~":kill-whole-line
# del key
#"\e[3~":delete-char
# end key
#"\e[4~":end-of-line
# pgup key
"\e[5~":history-search-forward
# pgdn key
"\e[6~":history-search-backward

# for xterm
"\eOH": beginning-of-line
"\eOF": end-of-line

# ---- End  /etc/inputrc
EOF
  message_ok "/etc/inputrc created"
fi


# fixes/creates the $CFLAGS :
#export CFLAGS="$CFLAGS $(uname -m |sed 's/i/-m/')"
#message_warning "CFLAGS set to $CFLAGS"


PACKAGE_TYPE_LIST="system net snd imgs"

for PACKAGE_TYPE in $PACKAGE_TYPE_LIST
do
  LFS_PKGS=$YGLFS/src/pkgs/$PACKAGE_TYPE
  LFS_CMD=$YGLFS/src/lfs-commands/$PACKAGE_TYPE
  if [ ! -d $LFS_PKGS ]
  then
    message_warning "skipping $PACKAGE_TYPE, package directory absent"
  else
    if [ ! -d $LFS_CMD ]
    then
      message_warning "skipping $PACKAGE_TYPE, command directory absent"
    else
      BASENAME_LIST=$(cat $LFS_CMD/basename_list) &&
      message_ok "starting $LFS_CMD" &&
      source $YGLFS/install_functions.sh || message_warning "   ### $PACKAGE_TYPE failed, proceeding anyway ###   "
    fi
  fi
done


# mouse + tablet setup :
if [ ! -c /dev/mice ]
then
  mknod /dev/mice c 13 63
  message_ok "/dev/mice created"
fi

if [ ! -e /etc/profile ]
then
  cat > /etc/profile << "EOF"
#!/bin/bash
# /etc/profile starts here
# because some deamons can't be started in init, they are
# launched at the first startup. that's ugly but it spares
# some efforts.
if [ ! -e /var/run/gpm.pid ]
then
  echo "starting mouse/tablet"
  gpm -t ps2 -m /dev/mice -M -t ps2 -m /dev/psaux
fi
EOF
  message_ok "/etc/profile created"
fi

if [ -z "$( grep 3c /etc/modules.conf)" ]
then
  message_warning "updating /etc/modules.conf"
  cat >> /etc/modules.conf << "EOF"
alias eth0 3c575_cb
alias dummy0 3c575_cb
alias sound-slot-0 i810_audio
#alias dummy0 3c59x
#alias eth0 3c59x
EOF
fi


#if [ ! -e /usr/yglfs/.strip.out ]
#then
#  find $LFS/{,usr/,usr/local/}{bin,sbin,lib} -type f \
#   -exec /usr/bin/strip -v --strip-debug '{}' ';' > /usr/yglfs/.strip.out 2>&1 &&
#  message_ok 'strip performed.' || message_ko 'strip failed, check /usr/yglfs/.strip.out'
#fi &&


echo ciao.
