-- ex_pipeline.vhdl -- example of a pipelined execution unit
-- Copyright (C) 2000 Yann GUIDON <whygee@f-cpu.org>
--
-- This is a configurable generic pipeline FF that is used inside
-- Execution Units. It can be removed with the "generic" parameter
-- or can be changed later to perform some boundary scan.
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

library IEEE;
use IEEE.std_logic_1164.all;
library WORK;
use WORK.PIPE_STAGE;

entity EU_EXAMPLE is
  generic (
    PIPESTAGES : natural := 3 -- for example :-)
  );
  port (
    Ck : in std_ulogic;
    Din : in std_ulogic_vector(20 downto 0);
    Dout : out std_ulogic_vector(20 downto 0)
-- etc.
  );
end EU_EXAMPLE;

architecture Arch_1 of EU_EXAMPLE is
  component PIPE_STAGE is
    generic ( Pass : boolean );
    port (
      Ck  : in std_ulogic;
      Din : in std_ulogic_vector;
      Dout : out std_ulogic_vector
    );
  end component;
  Signal D1,D2 : std_ulogic_vector(20 downto 0);
begin

-- stuff here....

  stage1: PIPE_STAGE
    generic map(PIPESTAGES=3)
    port map (Ck => Ck, Din => Din, Dout => D1);

-- stuff here....

  stage2: PIPE_STAGE
    generic map(PIPESTAGES=1 or PIPESTAGES=3)
    port map (Ck => Ck, Din => D1, Dout => D2);

-- stuff here....

  stage3: PIPE_STAGE
    generic map(PIPESTAGES=3)
    port map (Ck => Ck, Din => D2, Dout => Dout);

-- yet more stuff here again ...

end Arch_1;
