-- maj34.vhdl -- 3-of-4 majority gate
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: maj34.vhdl,v 1.2 2000/11/18 15:07:36 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity MAJ34 is
	port (
		A, B, C, D : in std_ulogic;
		Y : out std_ulogic
	);
end MAJ34;

architecture Behave_1 of MAJ34 is
begin
	Y <= (A and B and C)
	  or (B and C and D)
	  or (C and D and A)
	  or (D and A and B);
end Behave_1;
