-- fa.vhdl -- 1-bit full adder
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: fa.vhdl,v 1.4 2000/11/27 18:25:15 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity FA is
	port (
		A, B, C : in std_ulogic;
		Sum, Carry : out std_ulogic
	);
end FA;

architecture Struct_1 of FA is
	component XOR3
		port (A, B, C : in std_ulogic; Y : out std_ulogic);
	end component;

	component MAJ23
		port (A, B, C : in std_ulogic; Y : out std_ulogic);
	end component;
begin
	fa_sum : XOR3  port map (A => A, B => B, C => C, Y => Sum);
	fa_cry : MAJ23 port map (A => A, B => B, C => C, Y => Carry);
end Struct_1;
