-- pipeline.vhdl -- one pipeline stage buffer
-- Copyright (C) 2000 Yann GUIDON <whygee@f-cpu.org>
--
-- This is a configurable generic pipeline FF that is used inside
-- Execution Units. It can be removed with the "generic" parameter
-- or can be changed later to perform some boundary scan.
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

library IEEE;
use IEEE.std_logic_1164.all;

entity PIPE_STAGE is
      generic (
            PASS : boolean := true
      );
      port (
            Ck : in std_ulogic;
            Din : in std_ulogic_vector;
            Dout : out std_ulogic_vector
      );
end PIPE_STAGE;

architecture Arch_1 of PIPE_STAGE is
begin
do_pass: if PASS=true generate
            Dout <= Din;
      end generate;
-- else
no_pass: if PASS=false generate
            process (Ck)
            begin
                  if (Ck'event and Ck='1') then
                        Dout <= Din;
                  end if;
            end process;
      end generate;
end Arch_1;
