-- maj23.vhdl -- 2-of-3 majority gate
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: maj23.vhdl,v 1.1 2000/10/31 04:57:39 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity MAJ23 is
	port (
		A, B, C : in std_ulogic;
		Y : out std_ulogic
	);
end MAJ23;

architecture Struct_1 of MAJ23 is
	component AND2 is
		port (A, B : in std_ulogic; Y : out std_ulogic);
	end component;

	component OR3 is
		port (A, B, C : in std_ulogic; Y : out std_ulogic);
	end component;

	signal t1, t2, t3 : std_ulogic;
begin
	temp_1 : AND2 port map (A => A, B => B, Y => t1);
	temp_2 : AND2 port map (A => B, B => C, Y => t2);
	temp_3 : AND2 port map (A => C, B => A, Y => t3);
	maj_23 : OR3 port map (A => t1, B => t2, C => t3, Y => Y);
end Struct_1;
