-- pciarow.vhdl -- CIA_Row w/ Optional Input Register
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: pciarow.vhdl,v 1.1 2000/12/07 03:50:16 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity Piped_CIA_Row is
	generic (
		WIDTH : natural := 64;
		PIPELINED : boolean := false
	);
	port (
		-- generate/propagate inputs
		Gi : in std_ulogic_vector(WIDTH-1 downto 0);
		Pi : in std_ulogic_vector(WIDTH-1 downto 0);
		-- clock/reset inputs
		Clk : in std_ulogic := '0';
		Rst : in std_ulogic := '0';
	--
		-- carry/increment outputs
		Co : out std_ulogic_vector(WIDTH-1 downto 0);
		Io : out std_ulogic_vector(WIDTH-1 downto 0);
		-- generate/propagate outputs
		Go : out std_ulogic_vector((WIDTH-1)/4 downto 0);
		Po : out std_ulogic_vector((WIDTH-1)/4 downto 0)
	);
end Piped_CIA_Row;

architecture Struct_1 of Piped_CIA_Row is
	component CIA_Row
		generic (WIDTH : natural := 64);
		port (
			Gi : in std_ulogic_vector(WIDTH-1 downto 0);
			Pi : in std_ulogic_vector(WIDTH-1 downto 0);
			Co : out std_ulogic_vector(WIDTH-1 downto 0);
			Io : out std_ulogic_vector(WIDTH-1 downto 0);
			Go : out std_ulogic_vector((WIDTH-1)/4 downto 0);
			Po : out std_ulogic_vector((WIDTH-1)/4 downto 0)
		);
	end component;
	component PipeReg
		generic (WIDTH : natural := 64; DOREG : boolean := false);
		port (
			Clk, Rst : in std_ulogic;
			D : in std_ulogic_vector(WIDTH-1 downto 0);
			Q : out std_ulogic_vector(WIDTH-1 downto 0)
		);
	end component;

	signal r_Gi, r_Pi : std_ulogic_vector(WIDTH-1 downto 0);
begin
	reg_1 : PipeReg
		generic map (WIDTH => WIDTH, DOREG => PIPELINED)
		port map (D => Gi, Q => r_Gi, Clk => Clk, Rst => Rst);
	reg_2 : PipeReg
		generic map (WIDTH => WIDTH, DOREG => PIPELINED)
		port map (D => Pi, Q => r_Pi, Clk => Clk, Rst => Rst);
	core : CIA_Row
		generic map (WIDTH => WIDTH)
		port map (
			Gi => r_Gi, Pi => r_Pi,
			Co => Co, Io => Io, Go => Go, Po => Po
		);
end Struct_1;

-- vi: set ts=4 sw=4 equalprg="fmt -72 -p--": please
