-- ciainc.vhdl -- Carry-Increment Adder Output Incrementer
-- Copyright (C) 2000 Michael Riepe <michael@stud.uni-hannover.de>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: ciainc.vhdl,v 1.1 2000/12/02 14:31:52 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity CIA_Inc is
	generic (
		WIDTH : natural := 64;
		STEP : natural := 4
	);
	port (
		-- sum/carry inputs
		Yi : in std_ulogic_vector(WIDTH-1 downto 0);
		Ci : in std_ulogic_vector(WIDTH-1 downto 0);
		-- higher-level increment inputs
		Ii : in std_ulogic_vector((WIDTH-1)/STEP downto 0);
		-- carry select inputs
		Cs : in std_ulogic_vector((WIDTH-1)/STEP downto 0);
	--
		-- sum/carry outputs
		Yo : out std_ulogic_vector(WIDTH-1 downto 0);
		Co : out std_ulogic_vector(WIDTH-1 downto 0)
	);
end CIA_Inc;

architecture Struct_1 of CIA_Inc is
	component AND2
		port (A, B : in std_ulogic; Y : out std_ulogic);
	end component;
	component XOR2
		port (A, B : in std_ulogic; Y : out std_ulogic);
	end component;

	signal t : std_ulogic_vector(WIDTH-1 downto 0);
begin
	-- d=2
	res : for i in 0 to WIDTH-1 generate
		tmp : AND2 port map (Ci(i), Cs(i/STEP), t(i));
		sum : XOR2 port map (Yi(i), t(i), Yo(i));
		inc : AND2 port map (Ci(i), Ii(i/STEP), Co(i));
	end generate;
end Struct_1;

architecture Behave_1 of CIA_Inc is
begin
	-- d=2
	process (Yi, Ci, Ii, Cs)
		variable y, c : std_ulogic_vector(WIDTH-1 downto 0) := (others => '0');
	begin
		for i in 0 to WIDTH-1 loop
			y(i) := Yi(i) xor (Ci(i) and Cs(i/STEP));
			c(i) := Ci(i) and Ii(i/STEP);
		end loop;
		Yo <= y;
		Co <= c;
	end process;
end Behave_1;

-- vi: set ts=4 sw=4 equalprg="fmt -72 -p--": please
