#!/bin/sh
#
# YG's script for configuring the VHDL compilers/simulators environment.
# created Sat Sep 15 05:10:45 from various personal files
# updated Mon Sep 17 19:11:37 2001 : made more portable by MR
#


########################################################################################
# file cleanup
########################################################################################

# reset the configuration script
echo '#!/bin/sh'
echo '# Warning ! this file is automatically generated by tool_configure.sh !'

if [ -d work ]
then
    echo >&2 '    # removing work/'
    rm -R work
fi

if [ -d work.sym ]
then
    echo >&2 '    # removing work.sym/'
    rm -R work.sym
fi

if [ -e random ]
then
    if [ ! -L random ]
    then
	echo >&2 '    # notice : the file named random is not a symlink !'
    fi
else
    echo >&2 '    # creating a symlink to the random special file'
    ln -s /dev/urandom random
fi


########################################################################################
# (quickly) detect if simili/wine works :
########################################################################################
if wine -debugmsg -all "vhdlp" | grep "Symphony EDA (R) VHDL Compiler/Simulator" > /dev/null
then
    echo >&2 "    # simili/wine detected"
    echo 'export SIMILI_WINE=ok'
else
    echo >&2 "    # simili doesn't seem to work."
    echo 'unset SIMILI_WINE'
fi


########################################################################################
# detect if vanilla HDL works (using all possible means) :
########################################################################################

# locate is not portable... better do a path search.

# usage: pathof program-name [ path-to-search ]
pathof() {
    # protect caller from environment changes because we modify IFS.
    (
	IFS=":"
	for p in ${2:-$PATH}; do
	    if [ -x "$p/$1" ]; then
		# found it :)
		echo "$p/$1"
		return 0
	    fi
	done
	# not found :(
	return 1
    )
}

if mkvlib=$(pathof mkvlib)
then
    echo >&2 "    # Vanilla VHDL's mkvlib is detected in $mkvlib"

    # check if it works :
    mkvlib >outmessage 2>&1

    if grep "Usage: mkvlib directory_name" outmessage > /dev/null
    then
	echo >&2 '    # the dynamically linked version works !'
	echo 'export VANILLA_STATIC=on'
	mkvlib work >&2
    elif grep "can't load library" outmessage > /dev/null
    then
	echo >&2 '    # the dynamically linked version failed ! i will try with the static version.'
	if vv87 < /dev/null | grep 'Vanilla Cad VHDL System' > /dev/null
	then
	    echo 'export VANILLA_STATIC=off'
	    echo >&2 '    # i found the signature for the static version of Vanilla. cool !'
	    echo >&2 '    - making working directory -'
	    echo 'mkvlib work' | vv87 2>&1 | grep ERROR >&2
	else
	    echo >&2 ' ***** vv87 does not seem to work. Too bad, so close to success...'
	    echo 'unset VANILLA_STATIC'
	fi
    else
	echo >&2 '    # mkvlib failed. adios !'
	echo 'unset VANILLA_STATIC'
    fi
    rm -f outmessage
else
    echo >&2 '    # Vanilla VHDL not found. Maybe your PATH is not set correctly?'
    echo 'unset VANILLA_STATIC'
fi



########################################################################################
# check the other tools here
########################################################################################

