--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- Declaration of the random package
-- created Tue Sep 11 03:09:44 2001 by whygee@f-cpu.org
-- version Wed Sep 12 03:55:13 2001 : compiles with simili and vanilla.
-- version Wed Sep 12 06:47:04 2001 : simplified even more :-)
-- version dim dec 30 06:53:25 2001 : separated the declaration from the body
-- 
-- The purpose of this package is to provide an early (design-time)
-- way to test that a circuit does not reach an unstable state when
-- it is powered on.
--
-- IDEALLY, ALL "VARIABLES" SHOULD BE INITIALIZED WITH THIS PACKAGE !
--
-- this is intended for simulation only. Run a few times, to be sure that
-- different values are tested.
--
-- The problem is that it is not easy to create "real" random sequences,
-- we would get the same sequence all the time if an internal generator is
-- used. The first idea here is to read the special file /dev/urandom
-- (cf: $ man urandom)
--
-- But there is a problem : several platforms (non-Unix) don't have this
-- feature. Anyway the input can come from any file, preferably a compressed
-- archive or any file without repetitive sequences (ie: entropy).
-- The value of RANDOM_NAME allows you to change the file name.
-- 
-- If you can't to use /dev/urandom directly, either make a dump (with the command
--  $ dd if=/dev/urandom of=random bs=1024 count=20 ) or create a symlink :
--  $ ln -s /dev/urandom random (in the proper directory)
-------------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
--     USE ieee.numeric_std.all;

package random is

  constant RANDOM_NAME : string := "/dev/urandom";  -- the input file. See the comments above to create it.
  type byte_stream is file of character ;
  file random_file : byte_stream;  -- it is not opened here so we can close it and reopen it to "wrap around"

  function rand (var : in std_ulogic_vector)  -- the parameter is necesary to determine
    return std_ulogic_vector;                 --  the size (range) of the vector

  function rand (size : natural)  -- this is a "wrapper" that assumes a
    return std_ulogic_vector;     -- std_ulogic_vector(size-1 downto 0) as output.

  function rand    -- this "wrapper" returns a single bit.
    return std_ulogic;

  -- some "buttons" if you want to control the function more tightly :
  type init_type is (reset, set, random);
  constant random_mode : init_type := random;
  constant random_verbose : boolean := false;
  
end random;
