-- cat.vhdl, written by YG, sept. 2001
-- just a test to see if your tool can read "pure" binary data,
-- if you want to use the random package.
-- In the end, the program should write the size of the input
-- file named "in". If you remove the comments on the two other
-- lines, you can also test the output. You can create an
-- input file with the following command :
--    $ dd if=/dev/urandom of=in bs=1k count=10 

-- version dim dec 30 07:45:51 2001 : made it behave more like
--   Unix's "cat", for regression tests in a script.

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
LIBRARY std;
    USE std.textio.ALL;

entity cat is
  -- empty
end cat;

architecture tst of cat is
  type byte_stream is file of character ;
  file in_file  : byte_stream open read_mode is "in";
  file out_file : byte_stream open write_mode is "out";

begin  -- test
  process
    variable c : character;
    variable i : integer := 0;
    variable l : line;
  begin
    while not endfile(in_file) loop
      read(in_file,c);
      write(out_file,c);
      i := i+1;
    end loop;
     WRITE(l,i);
     WRITE(l,string'(" bytes read"));
     writeline(output, l);
    wait;
  end process;
end tst;
