--
--
--  LFSR as copied from the book
--  "VHDL for logic synthesis" 2nd ed. by  Andrew Rushton
--
--  This LFSR will be used in the BIST along with signature tables.
--  Warning : the tables were taken from Horowitz & Hill (1980)
--  and the tap numbering starts at 1. These parameters define
--  "perfect" LFSRs wich visit all states except 0 (reset starts
--  at all ones). the feedback is a simple xor between two elements.
--
--  Other tap tables can be found in the crypto litterature, ie Schneier
--  but the behaviour can differ.
-- 
--  Compiles with Vanilla and simili "fingers in the nose". the author
--  has 'only' forgotten a pair of parenthesis around the feedback's xor. 
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity LFSR is
  generic (
    bits : integer range 4 to 32);
  port (
    ck, rst : in  std_ulogic;
    q       : out std_ulogic_vector(bits-1 downto 0));
end lfsr;

architecture behaviour of LFSR is
  type table is array (natural range <>) of integer;
  constant sizes : table(4 to 32) :=
  (             4,  5,  6,  7,  9,
    9, 10, 11, 15, 15, 15, 15, 17,
   17, 18, 20, 20, 21, 22, 23, 25,
   25, 28, 28, 28, 29, 31, 31, 33);
  constant taps : table(4 to 32) :=
  (             3,  3,  5,  6,  5,
    5,  7,  9, 14, 14, 14, 14, 14,
   14, 11, 17, 17, 19, 21, 18, 22,
   22, 25, 25, 25, 27, 28, 28, 20);
  signal shifter : std_ulogic_vector(sizes(bits) downto 1);

begin  -- behaviour
  process
  begin
    wait until rising_edge(ck);
    if rst = '1' then
      shifter <= (others => '1');
    else
      shifter <= shifter(shifter'left-1 downto 1)  -- shift
                 & (shifter(shifter'left) xor shifter(taps(bits)));  -- feedback
    end if;
  end process;
  q <= shifter(bits downto 1);
end behaviour;
