/*

f-cpu/ygasm/ygasm.c : wrapper and main().

This is a Free Software created : ven avr 28 05:03:55 CEST 2000  by Yann GUIDON
It is a merger of PPCM (tiny C compiler, for the C syntax) and GRAZER (RISC assembler, for
the recursive #ifdef, #define, #include etc) 

Note : the original #define and #include mechanisms have been conserved from the GRAZER.
The label management has been rewritten with a different mechanism than linked list :
labels.c implements a binary tree which is O(log2(n)), while linked lists are O(n),
they are kept for #defines and #includes because they are less critical for the compile time.
Anyway, the old linked list code is still rather dirty...

update : Sun Jul 15 17:55:58 2001
i get back to the F-CPU assembler, under the name of ygasm.

*/

/* includes all the standard libs and defines most global variables and structures */
#include "ygasm.h"

/* all the "maintainance" features are stored in external,
   independent (from eachother) files.
   however, ygasm.l (then transformed into flex_ygasm.c by flex)
   contains a lot of other mixed stuffs. */
#include "ygasm_errors.c"   /* the basic error() stuff */
#include "ygasm_malloc.c"   /* defines void * ygasm_malloc(int req_size) */
#include "ygasm_labels.c"   /* identifier management routines : */
#include "ygasm_define.c"   /* #define management functions */
#include "ygasm_files.c"    /* file reading functions */
#include "ygasm_bin.c"      /* binary stream output functions */ 

/*
 *  Number passing between FLEX and BISON (instead of yylvalue)
 */

#define YYSTYPE u64   /* overloads the definition before parsing bison_ygasm.h
   so that mostly all numbers are huge and match the minimum F-CPU requirement. */

/* u64 yy_number; this is useless if YYSTYPE is redefined. */

int hex2int(char c)  /* used in the flex parser */
{
  if (c>='A') {
    if (c>='a')
      return c-'a'+10;
    else
      return c-'A'+10;
  }
  else
    return c-'0';
}


/* the "big" stuffs that are generated by bison and flex : */
#include "bison.h"
#include "flex.c"
#include "bison.c"

int main(int argc, char **argv){
  init_out_buff();
  init_flex(argc, argv);
  yyparse();
  flush_out_buff();
  return 0;
}
