#ifndef FCPU_PORTS_H
#define FCPU_PORTS_H

/* f-cpu/include/f-cpu_ports.h
   included by f-cpu/f-cpu_config.h

created Sun Aug 12 20:05:20 2001 by whygee@f-cpu.org

This file defines the names of the Xbar ports and
the values that are used to switch a specific data.
These values are used by Xbar_write_to_(x) and
Xbar_read_from_(x)

 */


/* Xbar_read_from_(x)  (Xbar Read cycle) : */
#define PORT_READ_FROM_REGISTER       0   /* the normal stuff */
#define PORT_READ_FROM_BYPASS_0       1   /* bypass write bus 0 */
#define PORT_READ_FROM_BYPASS_0_BIS   2   /* 1-cycle delay of the above (due to R7 latency) */
#define PORT_READ_FROM_BYPASS_1       3   /* bypass write bus 1 */
#define PORT_FROM_FROM_BYPASS_1_BIS   4   /* delay (R7 bypass #2) */
#define PORT_READ_FROM_IMMEDIATE      5   /* from the instruction deocder */
#define PORT_READ_FROM_CIP            6   /* from the fetcher */
#define PORT_READ_FROM_NIP            7   /* from the fetcher */


/* Xbar_write_to_(x)   (Xbar Write cycle) : */
#define PORT_WRITE_FROM_NOTHING       0    /* "nop" */
#define PORT_WRITE_FROM_REGISTER      1    /* register to register write */
#define PORT_WRITE_FROM_IMMEDIATE     2    /* similar to the above but copy from a different port */
#define PORT_WRITE_FROM_ROP2          3    /* ROP2 output */
#define PORT_WRITE_FROM_ASU           4    /* ASU main port */
#define PORT_WRITE_FROM_ASU2          5    /* ASU carry port */
#define PORT_WRITE_FROM_BIST0         6    /* BIST service port 0 */
#define PORT_WRITE_FROM_BIST1         7    /* BIST service port 1 */
/* other EU will be added : IDIV, MUL, INC, LSU,... */

#endif /* EOF */
