--------------------------------------------------------------------------
-- f-cpu/vhdl/registers/test_mux.vhdl - Testbench for the mux
-- Copyright (C) 2002 Etienne LABARRE (etienne.labarre@gadz.org)
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- Testbench for mux : test of a multiplexer 2**N --> 1
-- Constant TEST_WIDTH contains value of N.
-- 
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
-- text I/O
    use IEEE.std_logic_textio.all;
    use std.textio.all;
-- local functions
LIBRARY work;
    USE work.mux;

Entity test_mux is
  -- empty
end test_mux;

Architecture testbench_mux of test_mux is

  constant TEST_WIDTH : natural := 6;

  signal in_vector  : std_ulogic_vector(2**TEST_WIDTH-1 downto 0);
  signal sel_vector : std_ulogic_vector(TEST_WIDTH-1 downto 0);
  signal out_vector : std_ulogic;

begin

   -- Component under test :
   mux_1 : entity mux
      generic map( width => TEST_WIDTH )
      port map(
	 mux_select => sel_vector,
         mux_input  => in_vector,
	 mux_output => out_vector
	 );

   -- test bench :
   testbench : process is
      variable lout  : line;
      variable adress_count : std_ulogic_vector(TEST_WIDTH-1 downto 0);
      variable test_vector  : std_ulogic_vector(2**TEST_WIDTH-1 downto 0);

      -- procedure for increment adress
      procedure inc_add (
         inc_ad : inout std_ulogic_vector(TEST_WIDTH-1 downto 0) ) is
         variable tmp_ad : std_ulogic_vector(TEST_WIDTH-1 downto 0);
         variable  carry : std_ulogic;
         begin

            tmp_ad := inc_ad;
            carry  := '1';

            -- increment tmp_ad
	    for j in 0 to TEST_WIDTH-1 loop
	       if carry = '1' then
	          if tmp_ad(j) = '0' then
	             tmp_ad(j) := '1';
	             carry     := '0';
	          else
	             tmp_ad(j) := '0';
	             carry     := '1';
	          end if;
	       end if;
	    end loop;

	    inc_ad := tmp_ad;

      end procedure;

      -- procedure for apply input and print output
      procedure verify_output (
	 sel   : std_ulogic_vector(TEST_WIDTH-1 downto 0) ) is 

      begin  

	 sel_vector <= sel;
	 wait for 1 ns;
	 write(lout, out_vector);

      end verify_output;

      -- procedure for scan all adress range (2**N possibilities)
      procedure apply_vector (
         value : std_ulogic_vector(2**TEST_WIDTH-1 downto 0) ) is

      begin

         in_vector <= value;
	 wait for 1 ns;

         adress_count := (others => '0');
         write(lout, string'("result : "));
	 for i in 0 to 2**TEST_WIDTH-1 loop
            verify_output(adress_count);
	    inc_add(adress_count);
	 end loop;
	 writeline(output, lout);
   
      end procedure;
         
  begin    -- process
    write(lout, string'("  "));
    writeline(output, lout);
    write(lout, string'(" *** Start of tests *** "));
    writeline(output, lout);

    wait for 1 ns;
    
    -- test with a 1
    test_vector := (others => '0');
    test_vector(0) := '1';

    for i in 0 to 2**TEST_WIDTH-1 loop
       apply_vector(test_vector);

       for j in 2**TEST_WIDTH-2 downto 0 loop
          if test_vector(j) = '1' then
	     test_vector(j) := '0';
	     test_vector(j+1) := '1';
	  end if;
       end loop;
    end loop;

    -- test with a 0
    test_vector := (others => '1');
    test_vector(0) := '0';

    for i in 0 to 2**TEST_WIDTH-1 loop
       apply_vector(test_vector);

       for j in 2**TEST_WIDTH-2 downto 0 loop
          if test_vector(j) = '0' then
	     test_vector(j) := '1';
	     test_vector(j+1) := '0';
	  end if;
       end loop;
    end loop;

 
  wait;
  end process;

end; 
