--------------------------------------------------------------------------
-- f-cpu/vhdl/registers/test_demux.vhdl - Testbench for the demux
-- Copyright (C) 2002 Etienne LABARRE (etienne.labarre@gadz.org)
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- Testbench for demux : test of a demultiplexer 1 --> 2**N
-- Constant TEST_WIDTH contains value of N.
-- 
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
-- text I/O
    use IEEE.std_logic_textio.all;
    use std.textio.all;
-- local functions
LIBRARY work;
    USE work.demux;

Entity test_demux is
  -- empty
end test_demux;

Architecture testbench_demux of test_demux is

  constant TEST_WIDTH : natural := 6;

  signal out_vector : std_ulogic_vector(2**TEST_WIDTH-1 downto 0);
  signal sel_vector : std_ulogic_vector(TEST_WIDTH-1 downto 0);
  signal in_vector  : std_ulogic;
  signal others_vector  : std_ulogic;

begin

   -- Component under test :
   mux_1 : entity demux
      generic map( width => TEST_WIDTH )
      port map(
	 demux_select => sel_vector,
         demux_input  => in_vector,
	 demux_output => out_vector,
	 demux_others => others_vector
	 );

   -- test bench :
   testbench : process is
      variable lout  : line;
      variable adress_count : std_ulogic_vector(TEST_WIDTH-1 downto 0);
      variable test_vector  : std_ulogic_vector(2**TEST_WIDTH-1 downto 0);

      -- procedure for increment adress
      procedure inc_add (
         inc_ad : inout std_ulogic_vector(TEST_WIDTH-1 downto 0) ) is
         variable tmp_ad : std_ulogic_vector(TEST_WIDTH-1 downto 0);
         variable  carry : std_ulogic;
         begin

            tmp_ad := inc_ad;
            carry  := '1';

            -- increment tmp_ad
	    for j in 0 to TEST_WIDTH-1 loop
	       if carry = '1' then
	          if tmp_ad(j) = '0' then
	             tmp_ad(j) := '1';
	             carry     := '0';
	          else
	             tmp_ad(j) := '0';
	             carry     := '1';
	          end if;
	       end if;
	    end loop;

	    inc_ad := tmp_ad;

      end procedure;

      -- procedure for scan all adress range (2**N possibilities)
      procedure apply_vector (
         value : std_ulogic ) is

      begin

	 wait for 1 ns;

         adress_count := (others => '0');
	 for i in 0 to 2**TEST_WIDTH-1 loop
	    sel_vector <= adress_count;
	    wait for 1 ns;
            write(lout, string'("result : "));
	    write(lout, out_vector);
	    writeline(output, lout);
	    inc_add(adress_count);
	 end loop;
   
      end procedure;
         
  begin    -- process
    write(lout, string'("  "));
    writeline(output, lout);
    write(lout, string'(" *** Start of tests *** "));
    writeline(output, lout);

    wait for 1 ns;
    
    -- test with a 0 in 0s
    write(lout, string'(" *** test with a 0 in 0s ***"));
    writeline(output, lout);
    in_vector <= '0';
    others_vector <= '0';
    apply_vector('0');

    -- test with a 1 in 0s
    write(lout, string'(" *** test with a 1 in 0s ***"));
    writeline(output, lout);
    in_vector <= '1';
    others_vector <= '0';
    apply_vector('0');

    -- test with a 0 in 1s
    write(lout, string'(" *** test with a 0 in 1s ***"));
    writeline(output, lout);
    in_vector <= '0';
    others_vector <= '1';
    apply_vector('0');

    -- test with a 1 in 1s
    write(lout, string'(" *** test with a 1 in 1s ***"));
    writeline(output, lout);
    in_vector <= '1';
    others_vector <= '1';
    apply_vector('0');
 
  wait;
  end process;

end; 
