--------------------------------------------------------------------------
-- File vhdl/registers/mux.vhdl - Multiplexer for f-cpu
-- Copyright (C) 2002 Etienne Labarre (etienne.labarre@gadz.org)
-- Fri Mar  8 22:35:19 CET 2002
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- Multiplexer from 2**n to 1, with n > 1
--
--------------------------------------------------------------------------

-- include standard libraries
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.all;

-- Definition of mux entity
entity mux is
   generic( width : natural := 6 );
   port (
      mux_select : in  std_ulogic_vector(width-1 downto 0);
      mux_input  : in  std_ulogic_vector(2**width-1 downto 0);
      mux_output : out std_ulogic
      );
end mux;


-- Description of mux entity
architecture simple of mux is

begin

   main_proc : process (mux_input, mux_select) is

      variable tree_base  : integer;
      variable tree_width : integer;

      variable mux_tree   : std_ulogic_vector((2**width)*2-1 downto 0);
   begin

      for i in 0 to 2**width-1 loop
         mux_tree(i) := mux_input(i);
      end loop;

      tree_base  := 0;
      tree_width := 2**width;

      for i in 0 to width-1 loop
         for j in 0 to tree_width/2-1 loop
            case mux_select(i) is
	       when '0'      => mux_tree(tree_base+tree_width+j) := mux_tree(tree_base+2*j);
	       when '1'      => mux_tree(tree_base+tree_width+j) := mux_tree(tree_base+2*j+1);
	       when others   => mux_tree(tree_base+tree_width+j) := '0';
	    end case;

	 end loop;

	 tree_base  := tree_base + tree_width;
	 tree_width := tree_width/2;
      end loop;

      mux_output <= mux_tree(tree_base);

      end process;
end;
