--------------------------------------------------------------------------
-- File f-cpu/vhdl/registers/demux.vhdl - Demultiplexer for f-cpu
-- Copyright (C) 2002 Etienne Labarre (etienne.labarre@gadz.org)
-- Fri Mar  8 22:35:19 CET 2002
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- Demultiplexer from 2**n to 1, with n > 1
--
--------------------------------------------------------------------------

-- include standard libraries
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.all;

-- Definition of mux entity
entity demux is
   generic( width : natural := 6 );
   port (
      demux_input  : in std_ulogic;
      demux_select : in  std_ulogic_vector(width-1 downto 0);
      demux_output : out std_ulogic_vector(2**width-1 downto 0);
      demux_others : in std_ulogic
      );
end demux;


-- Description of mux entity
architecture simple of demux is

begin

   main_proc : process (demux_others, demux_input, demux_select) is

      variable tree_base  : integer;
      variable tree_width : integer;

      variable demux_tree   : std_ulogic_vector((2**width)*2-1 downto 0);
   begin


      tree_base  := 2*(2**width-1);
      tree_width := 2;

      demux_tree(tree_base) := demux_input;

      for i in 0 to width-1 loop
         for j in 0 to tree_width/2-1 loop
	    if demux_select(i) = '0' then
	       demux_tree(tree_base-tree_width+j)   := demux_tree(tree_base+j);
	       demux_tree(tree_base-tree_width/2+j) := demux_others;
	    else
	       demux_tree(tree_base-tree_width/2+j) := demux_tree(tree_base+j);
	       demux_tree(tree_base-tree_width+j)   := demux_others;
	    end if;
	 end loop;

	 tree_base  := tree_base - tree_width;
	 tree_width := tree_width*2;
      end loop;

      for i in 0 to 2**width-1 loop
         demux_output(i) <= demux_tree(i);
      end loop;

   end process;
end;
