#!/bin/sh

# f-cpu/vhdl/vanilla_fc0.sh, created lun dec 31 07:51:59 GMT 2001 by whygee@f-cpu.org
# this is a copy/paste of f-cpu/vhdl/simili_fc0.sh
# based on some older work done this summer by YG and MR, i cut-n-pasted the
# concatenation trick and removed the wine and detection stuffs.

# some configuration variables for compiling the FC0 core with Simili :
# these strings are formed with the rule : directory_name='file1 file2 file_n'
   configuration='f-cpu_config.vhdl f-cpu_opcodes.vhdl clock_config.vhdl'
          common='bit_manipulation.vhdl generic_adder.vhdl fanout.vhdl misc.vhdl random.vhdl random_clear.vhdl'
           clock='clock.vhdl clock_powerup.vhdl'
       scheduler='scheduler_definitions.vhdl decoding_table.vhdl scheduler_issue.vhdl scheduler_queue.vhdl'
         eu_rop2='rop2_unit.vhdl rop2_xbar.vhdl'
          eu_asu='iadd.vhdl asu.vhdl'
          eu_imu='imul64.vhdl imu.vhdl'
          eu_shl='shuffle64.vhdl'
#           eu_sr='eu_sr.vhdl'  cause : impure function not supported by vanilla

# list of the directory names in the good order :
     directories='configuration common clock eu_rop2 eu_asu eu_imu eu_shl'

#concatenation of everything :
files=
for j in $directories
do
    eval k=\${$j}	# this trick is even better :) --MR
    for l in $k
    do
	files="$files $j/$l" # concatenation
    done
done

if [ ! -d work ]
then
  mkvlib work
  echo "     working directory created. "
fi


#run the tool with all the files in the command line
va87 -x $files 

echo " That's all, folks !"
echo
