#! /bin/sh
# YG's small dirty script for compiling the FC0 with Simili under wine
# created Sat Sep  8 04:15:12 2001
# updated Fri Sep 14 07:42:49 2001 : added the array of filenames
# updated Mon Sep 17 19:11:37 2001 : made more portable by MR

# use /bin/sh unless CONFIG_SHELL is set
: ${CONFIG_SHELL=/bin/sh}

# check if the detection is already performed :
if [ ! -f tools.env ]
then
    ${CONFIG_SHELL} tool_configure.sh > tools.env
fi
# load configuration
. ./tools.env

# check the result
if [ x"${SIMILI_WINE-unset}" = xunset ]
then
    echo >&2 ' # could not run Simili : aborting.'
    exit 1
fi

#these strings are formed with the rule : directory_name='file1 file2 file_n'
   configuration='f-cpu_config.vhdl f-cpu_opcodes.vhdl clock_config.vhdl'
          common='generic_adder.vhdl random.vhdl'
         eu_rop2='rop2_xbar.vhdl rop2_unit.vhdl'

# list of the directory names
     directories='configuration common eu_rop2'

#concatenation of everything :
files=
for j in $directories
do
    eval k=\${$j}	# this trick is even better :) --MR
    for l in $k
    do
	files="$files $j/$l" # concatenation
    done
done

#run the tool with all the files in the command line
# (avoids the latency time from wine's setup)
wine -debugmsg -all "vhdlp -nostderr -s -strict $files"
