#!/bin/sh
# 
# install.sh
# 
# Copyright (c) 2001 by Symphony EDA 
# 
# Date  : Nov 16, 2001
# Author: Haneef D. Mohammed (haneef)
# 
# Description:
# 
# Installation script for installing VHDL Simili
#
# Revision History:
# 
# 

QueryYesNo()
{
    prompt="$1"
    dflt="$2"
    while true ; do
	echo -n "$prompt"
	read ans
	case "$ans" in
	"")
	    if test "$dflt" = "" ; then
		echo "Error: No default response. Please enter a \"yes\" or \"no\"."
		continue
	    fi
	    return $dflt
	    ;;
	y|Y|yes|YES)
	    return 0
	    ;;
	n|N|no|NO)
	    return 1
	    ;;
	*)
	    echo "Error: Invalid response \"$ans\", expected a \"yes\" or \"no\"."
	    continue
	    ;;
	esac
    done
}

QueryInstallDirectory ()
{
    defdir="/usr/local/Simili20"
    os=`uname -s`
    rel=`uname -r`
    case "$os" in
    SunOS)
      case "$rel" in
        4.1.3*|4.1.4*|4.1C) echo "OS release SunOS $rel not supported" ; exit 1 ;;
        5.*) defdir="/opt/Simili20" ;;
      esac
      ;;
    esac

    while [ -z "$idir" ] ; do
	idir="$defdir"
        echo " "
	echo "Please enter installation directory for VHDL Simili 2.0"
	echo -n "[default = ${idir}] : "
	read ans
	case "$ans" in
	"")
	    ;;
	/)
	    idir=
	    echo "Error: Should not use / as the installation directory"
	    continue
	    ;;
	/*)
	    idir="$ans"
	    ;;
	*)
	    idir=
	    echo "Error: Please enter a full path name to the installation directory"
	    continue
	    ;;
	esac

	if [ ! -d "$idir" ] ; then
	    echo " "
	    msg="Direcotry \"$idir\" does not exist. Do you want to create it now? [y] : "
	    if QueryYesNo "$msg" 0 ; then
		mkdir -p "$idir"
	    else
		idir=
		continue
	    fi
	    if [ ! -d "$idir" ] ; then
		echo "Error: Cannot create directory \"$idir\"."
		idir=
		continue;
	    fi
	else
	    echo " "
	    msg="Direcotry \"$idir\" already exists. Do you want to overwrite it? [y] : "
	    if ! QueryYesNo "$msg" 0 ; then
		idir=
		continue
	    fi
        fi
	if ( echo foo > "$idir/testfile.txt" ) 2> /dev/null ; then
	    rm -f "$idir/testfile.txt"
	    if [ -e "$idir/testfile.txt" ] ; then
		echo "Error: Cannot write to directory \"$idir\"."
		idir=
	    fi
	else
	    echo "Error: Cannot write to directory \"$idir\"."
   	    idir=
	fi
    done

    eval $1="$idir"
}

################################################################################

echo "Symphony EDA installer for VHDL Simili"
echo "Copyright (C) 2000-2001 Symphony EDA. All rights reserved."
echo " "

if ! QueryYesNo "You are about to install VHDL Simili 2.0. Continue? [y] : " 0 ; then
    exit 1
fi

tfile=./Simili20b14b-linux-x86-image.tgz
if test ! -e "$tfile" ; then
    echo "Error: Could not find $tfile"
    exit 1
fi

if test -e ./license.txt ; then
    more ./license.txt
else
    echo "Error: Could not find license.txt"
    exit 1
fi

echo " "
if ! QueryYesNo "Do you accept this license? y/n : " "" ; then
    echo "Note: Aborting installation because license agreement declined"
    exit 1
fi

QueryInstallDirectory idir

if test "$idir" = "" ; then
    echo "Error: Exiting because no installation directory specified"
    exit 1
fi

if test -d "$idir/lib" -a -d "$idir/lib/ieee" ; then
    if test -d "$idir/lib/ieee/ieee.sym" ; then
	echo " "
	echo "Note: It appears that you are installing upon an existing installation"
	echo "The install script must delete the \"$idir/lib\" to proceed"
	echo " "
	if ! QueryYesNo "Is it okay to delete \"$idir/lib\"? [y] : " 0 ; then
	    echo "Note: Aborting installation because deleting of \"$idir/lib\" denied by user"
	    exit 1
	fi

    fi
fi

if test -d "$idir/lib" ; then
    echo "Deleting $idir/lib ..."
    rm -fr "$idir/lib"
fi

echo "Copying files to \"$idir\" ..."
zcat "$tfile" | (cd "$idir" ; tar xf - )

if [ -e "$idir/bin/freelic.txt" ] ; then
    if [ -e "$idir/bin/symphony.lic" ] ; then
	echo "$idir/bin/symphony.lic alread exists. Skipping copying of default license file"
    else
	cp "$idir/bin/freelic.txt" "$idir/bin/symphony.lic"
    fi
fi

echo "Done copying files"
echo ""
if ! QueryYesNo "Do you want to see instructions for setting up your environment? [y] : " 0 ; then
    exit 0
fi

echo '--------------------------------------------------------------------------'
echo 'You have just installed VHDL Simili. Please add the following commands'
echo 'to your shell initialization file (~/.bashrc or ~/.cshrc or ~/.profile)'
echo " "
echo 'bash, sh users:'
echo " "
echo "    export SYMPHONYEDA=\"$idir\""
echo "    . \"\$SYMPHONYEDA/bin/init.sh\""
echo " "
echo 'csh users:'
echo " "
echo "    setenv SYMPHONYEDA \"$idir\""
echo "    source \"\$SYMPHONYEDA/bin/init.csh\""
echo " "
echo "VHDL Simili uses FLEXlm to manage licenses. Plase read the License Management"
echo "setup instructions for Unix in the following documentation (chapter 3)"
echo " "
ls -l "$idir"/doc/index.htm "$idir"/doc/*.pdf
echo " "
echo "The VHDL Simili toolset primarily consists of the following commands:"
echo " "
echo "1. sonata  -- This is the Graphical User Interface for Simili tools"
echo "2. vhdlp   -- This is the command-line VHDL compiler"
echo "3. vhdle   -- This is the command-line VHDL simulator"
echo " "
echo "You can use the following command to request licenses:"
echo " "
echo "    sonata -L"
echo " "
echo "If you are a new user of sonata, it will be very helpful for you to go"
echo "through the tutorial (approx. 15-30 minutes) included in the documentation."
echo '--------------------------------------------------------------------------'
echo "Thank you for trying out VHDL Simili. Good Bye."

exit 0
