/*

f-cpu/ygasm/ygasm_malloc.c

This is a Free Software created : ven avr 28 21:08:06 CEST 2000 by Yann Guidon

This is a malloc() wrapper that tries to prevent memory fragmentation.
It does so by allocating memory with large fixed size chuncks.
This is a dumb version that does not manage memory block deallocation 
(free()) because the application does not need it. This simplifies things
in fact : it is "allocate and exit". It does not try to squeeze the last
bit of every block too.

Sun Jul 15 18:56:19 2001 : adaptation for ygasm
(this file was previously named MY_MALLOC.C)

dim mar 17 06:41:46 GMT 2002
re-adding forward symbol definition.
To prevent memory leaks, memory re-allocation is necesary.
So i have to rewrite the corresponding code.

lun mar 18 00:19:40 GMT 2002
Now rewriting the functions ...

*/


#include <stdlib.h>
/* should be already included by ygasm.h */

/* global stats : */
unsigned int
  allocated_blocks=0,
  malloc_calls=0,
  free_calls=0,
  realloc_calls=0;


/* version without buffering (warning about the fragmentation !) */
#ifdef YGASM_RAW_MALLOC


void * ygasm_malloc(int req_size) {
  char *p;

  malloc_calls++;


       void *calloc (size_t nmemb, size_t size);
       void *malloc (size_t size);
       void free (void *ptr);
       void *realloc (void *ptr, size_t size);


#else
#ifdef YGASM_MALLOC_AND_EXIT

#define BLOCK_GRANULARITY 8192
char *current_block=NULL;
int block_size=BLOCK_GRANULARITY;

void * ygasm_malloc(int req_size) {
  char *p;

  malloc_calls++;

/* round up */
  req_size=(req_size+(sizeof(int*)-1))&(-sizeof(int*));

/* sanity check */
  if (req_size>BLOCK_GRANULARITY)
    ygasm_error("can't allocate memory : requested block is too large",NULL);

  if (block_size+req_size>BLOCK_GRANULARITY) {
    current_block=calloc(1,BLOCK_GRANULARITY);
    if (current_block==NULL)
      ygasm_error("can't allocate memory",NULL);
    block_size=req_size;
    allocated_blocks++;
    return current_block;
  }

  /* else */
  p=&current_block[block_size];
  block_size+=req_size;
  return p;
}

void ygasm_free(void *p) {
  free_calls++;
  ygasm_warning("  ygasm_free() not implemented.\n",NULL);
  /*
    we have to
      - clear (memset) the freed block (and all headers !)
      - add some flags to the allocated blocks (a header with size and flag)
      - support merge of contiguous free blocks (backwards and forwards)
      - support splitting of larger blocks
      - create a linked list of free blocks, so ygasm_malloc will scan it
        first before creating a new block

    an algorithm that can be better than linked lists :
    creating a block for each type of size
    but with variable name lengths, this is probably difficult.
    (the #defines and the variable names can require a large
    and uneven amount of memory)

  */
}

void ygasm_realloc(void *p) {
  realloc_calls++;
  ygasm_error("  ygasm_realloc() not implemented.\n",NULL);
}


#else


#error "Error : new malloc functions not yet implemented !"


#endif
#endif
