/*

 f-cpu/ygasm/ygasm.h :

This is a Free Software created ven avr 28 14:51:39 CEST 2000 by Yann GUIDON
Sun Jul 15 18:00:28 2001 : renamed from gnl_node.h to ygasm.h
Sat Sep  1 07:31:18 2001 : some updates in the directory structure.
lun mar 18 00:34:15 2002 : rebuild from scratch

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <f-cpu_config.h>     /* common F-CPU ressource file */
/* don't forget the "-I../include/" argument when calling GCC ! */

/*********************************************************
 here we put global variables for the parser and analyser.
 *********************************************************/

#ifdef erozgieviuhzeuyvhez

unsigned int
/* for the IFDEF stuffs */
 skip_count=0,    /* depth of the skipped #IFDEFs */
 ifdef_count=0,   /* flag for ifdef->endif (nesting count) */
#define MAX_IFDEF (sizeof(int)*8) /* it's implementation dependent ! */
 else_count=0,    /* flag for only one #ELSE  -> ACTUALLY this is a bit stack ! */
 warning_count=0,          /* is it THAT useful ? */
 count_nested_comments=0,  /* nested comments counter */
 enable_nested_comments=1000, /* can be modified within the parser */
 Line_Number=1,            /* the global one */
 parse_line,               /* line_number of the beginning of the instruction */
 verbosity=0;              /* enables/disables some warnings on stderr/stdout */

FILE *out_file;

/* FILE DESCRIPTOR used as a (linked) "include" stack */
struct include_node {
  void * next;          /* linked list, terminated by p->next==p */
  FILE *input_file;     /* backup of the global variable */
  int node_line_number; /* backup */
  char filename[1];     /* first byte of a normal string */
} *include_prec;        /* points to the last valid node, that is: the current file */

/* #DEFINEs and other preprocessor commands */
struct define_node {
  void * next;         /* linked list, finished when p->next==NULL */
  int line;            /* where it is DEFINed */
  struct define_node * last_scan; /* is an include_node when NULL, a *define_node otherwise */
  char *buffer;        /* where the definition is stored; uses realloc */
  int buffer_size;     /* number of char. in the buffer */
  signed int char_counter; /* points to the next char to be read, -1 if not in use */
  char string[1];      /* this byte only contains the size (like with PASCAL strings): */
} *define_prec=NULL, /* tail of the linked list */
  *current_define=NULL;     /* the one that's currently read from */


#define UNDEFINED_LITTLE_ENDIAN     0  /* the MSB defines the endianness */
#define UNDEFINED_BIG_ENDIAN        1  /* all other references are thus incremented by 2 */
/* fixing the immediate data in the instructions : */
#define UNDEFINED_IMM8              0
#define UNDEFINED_IMM16             2
/* fixing the immediate data outside the instructions : */
#define UNDEFINED_DB                8
#define UNDEFINED_DW               10
#define UNDEFINED_DD               12
#define UNDEFINED_DQ               14

typedef struct struct_undefined {
  struct struct_undefined * next; /* if not NULL, the linked list continues */
  unsigned int type_flag;         /* what kind of relocation */
  void * address;                 /* points to the location to fix */
} ;

typedef struct struct_symbol {
  int size; /* strlen */
  u64 value; /* for the labels and other stuffs */
  int attributes; /* will be extended later, for type checking for example */
  int line;  /* where the label is defined (sometimes, declared as global, then overwritten) */
  struct include_node *include_file; /* points to the file desriptor (for the error messages) */
  struct struct_symbol * left, *right; /* binary tree pointers */
  struct struct_undefined *list;    /* if not null, the symbol has not been yet defined */
  char name[0]; /* dirty trick, but it works... */
} symbol;

symbol *referenced_symbol;


#endif
