-----------------------------------------------------------------------
-- f-cpu/vhdl/scheduler/scheduler_issue.vhdl
-- FC0's scheduler issue logic
-- Copyright (C) 2001 Yann GUIDON (whygee@f-cpu.org)
-- created dim dec 23 04:07:43 GMT 2001 by whygee@f-cpu.org
--
--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------
--
-- First revision : let's see if it works :-)
--
-- This part is not very difficult to understand :
-- this is a big AND/OR that gathers all the flags and informations
-- about the pipeline states and the available ressources, it compares
-- everyone with the necessary ressources as reported from the opcode
-- by the LUT. Everything is ANDed into a single bit : "issue".
--
-- However there is a "little" problem : this logic is not "free" and
-- uses some "time" in the pipeline stage, it is necessary to pipeline
-- it at some point (which is currently undetermined). For the sake of
-- simplicity, we assume (for this first example) that the pipeline latch
-- is put on the output signal, but in reality it must be pushed
-- towards the input signals. This can be determined only on a
-- case-by-case basis, depending on the tools and the target technology.
--
-----------------------------------------------------------------------


LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
LIBRARY work;
    USE work.scheduler_definitions.ALL;


entity scheduler_issue is
  port (
    -- in
    clk : in Std_ulogic;
    -- from the scheduler's LUT :
    LUT : in t_dec_interface;
    -- from the scheduling queue :
    slot1_busy, slot2_busy : in Std_ulogic_vector(SQ_depth-1 downto 0);
    R1_busy, R2_busy, R3_busy, R4_busy : in Std_ulogic;
    -- missing : conditions from the register set, pointer checks from the LSU and the fetcher.

    -- out
    issue : out Std_ulogic
    -- we need to output some more data for the SQ ...
  );
end scheduler_issue;

architecture first_try of scheduler_issue is
  signal t_issue : Std_ulogic;
begin  -- first_try

  t_issue <=
         not LUT.bad_opcode
    and (not (R1_busy and LUT.requires_src1))
    and (not (R2_busy and LUT.requires_src2))
    and (not (R3_busy and LUT.requires_src3))  -- this is a bad approximation
    and (not (R2_busy and LUT.writes_ptr))     -- because the 2-level bypass modifies the rules
    and (not (R3_busy and LUT.writes_dest1))
    and (not (R4_busy and LUT.writes_dest2))
--    and Std_ulogic'((LUT.latency1 and slot1_busy)="00000000")
--    and Std_ulogic'((LUT.latency2 and slot2_busy)="00000000")
-- AAARgh ! it doesn't work. so let's do it "a la gruik" :
    and (not (LUT.latency1(0) and slot1_busy(0)))
    and (not (LUT.latency1(1) and slot1_busy(1)))
    and (not (LUT.latency1(2) and slot1_busy(2)))
    and (not (LUT.latency1(3) and slot1_busy(3)))
    and (not (LUT.latency1(4) and slot1_busy(4)))
    and (not (LUT.latency1(5) and slot1_busy(5)))
    and (not (LUT.latency1(6) and slot1_busy(6)))
    and (not (LUT.latency1(7) and slot1_busy(7)))
    and (not (LUT.latency2(0) and slot2_busy(0)))
    and (not (LUT.latency2(1) and slot2_busy(1)))
    and (not (LUT.latency2(2) and slot2_busy(2)))
    and (not (LUT.latency2(3) and slot2_busy(3)))
    and (not (LUT.latency2(4) and slot2_busy(4)))
    and (not (LUT.latency2(5) and slot2_busy(5)))
    and (not (LUT.latency2(6) and slot2_busy(6)))
    and (not (LUT.latency2(7) and slot2_busy(7)))
    
    -- this is still very incomplete ! but it gives you an idea about how
    -- boring this thing is...
    ;

--  LUT  flag  issue
--   0    X     1
--   1    0     0
--   1    1     1
--   issue <= flag or not LUT
--
--  LUT  flag  issue
--   0    X     1
--   1    0     1
--   1    1     0
--   issue <= not (flag and LUT)

  new_register: process (clk)
  begin  -- process
    if rising_edge(clk) then
      issue <= t_issue;
    end if;
  end process;

end first_try;
