-------------------------------------------------------------------------------
-- f-cpu/vhdl/registers/test_register_set.vhdl : a testbench for the F-CPU register set,
-- created sat. feb. 9 04:40:36 GMT 2002 by whygee@f-cpu.org
-- version Thu Jul  4 05:00:05 2002 : riviera hicups on rand => renamed.
--
-- This file is copied from test_sram3r2w.vhdl and it tries to stress
-- the register set (a bit). Timing is not verified but coherence of the 0 flag
-- is critical (too). It's not complete but it seems to work...
-- A more complete test is necessary, but it will probably be done in BIST.
--
--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
    USE IEEE.std_logic_textio.all;
    USE std.textio.all;
LIBRARY work;
    USE work.random.all;
    USE work.FCPU_config.ALL;
    USE work.register_set;

entity test_registers is
  -- empty
end test_registers;


architecture testbench of test_registers is
  signal clk : std_ulogic := '0';

-- Stimuli :
  signal read_address_0, read_address_1, read_address_2,
     write_address_0, write_address_1 : t_reg := (others => '0');
  signal write_port_0, write_port_1 : F_VECTOR := (others => '0');

-- Results :
  signal read_port_0, read_port_1, read_port_2 : F_VECTOR;
  signal MSB, LSB, zero, NaN : std_ulogic;
    -- NaN is implemented only when FP exists --> not tested.
  signal align : std_ulogic_vector(LOGMAXSIZE-1 downto 0);

  constant const_align_0 : std_ulogic_vector(LOGMAXSIZE-1 downto 0) := (others => '0');
  constant const_align_1 : std_ulogic_vector(LOGMAXSIZE-1 downto 0) := (others => '1');


begin  -- testbench

  R7 : entity register_set
    port map (
    R7_clk => clk,

    R7_read_address_0 => read_address_0,
    R7_read_address_1 => read_address_1,
    R7_read_address_2 => read_address_2,

    R7_read_port_0 => read_port_0,
    R7_read_port_1 => read_port_1,
    R7_read_port_2 => read_port_2,
    R7_MSB => MSB,
    R7_LSB => LSB,
    R7_zero => zero,
    R7_NaN => NaN,
    R7_align => align,

    R7_write_address_0 => write_address_0,
    R7_write_address_1 => write_address_1,
    R7_write_port_0 => write_port_0,
    R7_write_port_1 => write_port_1
  );

  test_driver : process
    variable lout : line;

    -- describe the register set array :
    type RAM_ARRAY_TYPE is array(63 downto 1) of F_VECTOR; -- the 63 registers
    variable RAM_ARRAY : RAM_ARRAY_TYPE;

    procedure clock_cycle is
    begin
      wait for 1 ns;
      clk <= '1';
      wait for 1 ns;
      clk <= '0';
    end clock_cycle;

  begin

-- 1) clear the register set :

    write_port_0 <= (others => '0');
    write_port_1 <= (others => '0');

    for i in 0 to 31 loop
      write_address_0 <= std_ulogic_vector(to_unsigned(i*2,6));
      write_address_1 <= std_ulogic_vector(to_unsigned(i*2+1,6));
      clock_cycle;
    end loop;

    write_address_0 <= (others => '0');
    write_address_1 <= (others => '0');    

-- 2) verify that the register set is correctly cleared :
    for i in 0 to 63 loop
      read_address_0 <= std_ulogic_vector(to_unsigned(i,6));
      read_address_1 <= std_ulogic_vector(to_unsigned(i,6));
      read_address_2 <= std_ulogic_vector(to_unsigned(i,6));
      wait for 1 ns;

      assert read_port_0 = F_VECTOR'(others => '0')
        report "Read port 0 returns wrong value"
        severity FAILURE;

      assert read_port_1 = F_VECTOR'(others => '0')
        report "Read port 1 returns wrong value"
        severity FAILURE;

      assert read_port_2 = F_VECTOR'(others => '0')
        report "Read port 2 returns wrong value"
        severity FAILURE;

      assert zero = '0'
        report "ZERO is not zero"
        severity FAILURE;

      assert MSB = '0'
        report "MSB is not zero"
        severity FAILURE;

      assert LSB = '0'
        report "LSB is not zero"
        severity FAILURE;

      assert align = const_align_0
        report "ALIGN is not zero"
        severity FAILURE;

      wait for 1 ns;
    end loop;

-- 3) write some other data :
    write_port_0 <= (others => '1');
    write_port_1 <= (others => '1');

    for i in 0 to 31 loop
      write_address_0 <= std_ulogic_vector(to_unsigned(i*2,6));
      write_address_1 <= std_ulogic_vector(to_unsigned(i*2+1,6));
      clock_cycle;
    end loop;

    write_address_0 <= (others => '0');
    write_address_1 <= (others => '0');

-- 4) verify that the register set is correctly set :
    for i in 1 to 63 loop
      read_address_0 <= std_ulogic_vector(to_unsigned(i,6));
      read_address_1 <= std_ulogic_vector(to_unsigned(i,6));
      read_address_2 <= std_ulogic_vector(to_unsigned(i,6));
      wait for 1 ns;

--      write(lout, now);
--      write(lout, string'(" Adr="));
--      write(lout, read_address_0);
--      write(lout, string'(" Read0="));
--      write(lout, read_port_0);
--      writeline(output, lout);

      assert read_port_0 = F_VECTOR'(others => '1')
        report "Read port 0 returns wrong value"
        severity FAILURE;

      assert read_port_1 = F_VECTOR'(others => '1')
        report "Read port 1 returns wrong value"
        severity FAILURE;

      assert read_port_2 = F_VECTOR'(others => '1')
        report "Read port 2 returns wrong value"
        severity FAILURE;

      assert zero = '1'
        report "ZERO is not 1"
        severity FAILURE;

      assert MSB = '1'
        report "MSB is not 1"
        severity FAILURE;

      assert LSB = '1'
        report "LSB is not 1"
        severity FAILURE;

      assert align = const_align_1
        report "ALIGN is not 1"
        severity FAILURE;

      wait for 1 ns;
    end loop;

-- 5) and now verify that R7 can remember other numbers :

    RAM_ARRAY(1) := rand_size (UMAX);
    write_port_0 <= RAM_ARRAY(1);
    write_address_0 <= std_ulogic_vector(to_unsigned(1,6));
    write_address_1 <= std_ulogic_vector(to_unsigned(0,6));
    clock_cycle;

    for i in 1 to 31 loop
      RAM_ARRAY(i*2)   := rand_size (UMAX);
      RAM_ARRAY(i*2+1) := rand_size (UMAX);

      write_port_0 <= RAM_ARRAY(i*2);
      write_port_1 <= RAM_ARRAY(i*2+1);

      write_address_0 <= std_ulogic_vector(to_unsigned(i*2,6));
      write_address_1 <= std_ulogic_vector(to_unsigned(i*2+1,6));
      clock_cycle;
    end loop;

    write_address_0 <= (others => '0');
    write_address_1 <= (others => '0');

    for i in 0 to 20 loop
      read_address_0 <= std_ulogic_vector(to_unsigned(i*3+1,6));
      read_address_1 <= std_ulogic_vector(to_unsigned(i*3+2,6));
      read_address_2 <= std_ulogic_vector(to_unsigned(i*3+3,6));
      wait for 1 ns;

      assert read_port_0 = RAM_ARRAY(i*3+1)
        report "Read port 0 returns wrong value"
        severity FAILURE;

      assert read_port_1 = RAM_ARRAY(i*3+2)
        report "Read port 1 returns wrong value"
        severity FAILURE;

      assert read_port_2 = RAM_ARRAY(i*3+3)
        report "Read port 2 returns wrong value"
        severity FAILURE;

--      assert LSB = RAM_ARRAY(i*3+1,0)
--        report "LSB is not coherent"
--        severity FAILURE;

---------------------------------------
-- missing : testing LSB, MSB and zero
-- (no idea/time to do it now)
---------------------------------------

      wait for 1 ns;
    end loop;

    wait; -- the end.
  end process;

end testbench;
