-------------------------------------------------------------------------------
-- sram2r3w.vhdl : a basic multiport SRAM bloc for building the F-CPU register set
-- created sat. feb. 9 04:40:36 GMT 2002 by whygee@f-cpu.org
-- updated Mon Jun 24 01:02:14 CEST 2002 by same, changing to type t_reg.
--       and removing WriteEn 
--
--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------
--
-- The SRAM building block is to be replaced, whenever needed, by appropriate
-- and technology-dependent multiported RAM blocks.
--
-- The first problem is the multiporting : this block can be implemented with
-- several smaller blocks, for examples 3 blocks that provide 1 read and 2
-- writes per cycle, or something more sophisticated.
--
-- The second problem is the timing : it is believed that the clock cycle is so
-- short that write and read to a same location can not occur. Shortly put :
-- the transmission time + setup + hold + read access delay is so long that
-- only read OR write is allowed on a given register (so it's only write access
-- time + setup + hold OR read access time).
--
-- The third (and worst) problem is the clocking : it seems to be impossible to
-- spread the clock tree through all the R7 so i thought to use "asynchronous"
-- logic but it would be timing-dependent ... The use of "transparent latches",
-- which require a few less transistors per bit and have some potential of
-- working faster, would have been helpful but F-CPU can't rely on timing tricks,
-- only on cycle tricks, and it's already too tight.
--
-- In the end, it is going to depend on the available technology.
--
-- Here is only the interface.
--
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
LIBRARY work;
    USE work.FCPU_config.ALL;

entity sram3r2w is
  
  generic (
    width : natural  -- number of bits per register in the sub-block
  );

  port (
    AdrRead1, AdrRead2, AdrRead3, AdrWrite1, AdrWrite2 : in t_reg;
    DataWrite1, DataWrite2 : in std_ulogic_vector(width-1 downto 0);
    DataRead1, DataRead2, DataRead3 : out std_ulogic_vector(width-1 downto 0);
    clk : in std_ulogic
  );

end sram3r2w;
