--------------------------------------------------------------------------
-- f-cpu/vhdl/eu_rop2/test_rop2.vhdl - Yet Another ROP2 Testbench for the F-CPU
-- Copyright (C) 2001 Yann GUIDON (whygee@f-cpu.org)
--
-- created sam dec  1 05:17:51 GMT 2001
-- version jeu dec  6 17:35:53 GMT 2001
-- version lun dec 10 02:33:00 GMT 2001 : added rand() and explicit functional
--    testing. Missing : logarithmic vector generation but rand() is enough now.
-- version Thu Jul  4 05:00:05 2002 : riviera hicups on rand => renamed.
--
--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------
--
-- This software generates stimuli to a file which will be read by the ROP2
-- wrapper.
--
--------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
    use IEEE.std_logic_textio.all;
    use std.textio.all;
LIBRARY work;
    USE work.FCPU_config.ALL;
    USE work.random.all;

Entity vect_rop2 is
  generic (FILENAME : string := "vect_rop2.hex" );
end vect_rop2;

Architecture arch1 of vect_rop2 is
    file stimulus: TEXT open write_mode is FILENAME;

begin   --  arch1 of vect_rop2

-- test vectors :
  vectors : process is
--    variable a, b, c : bit;
    variable k : integer;
    variable lout : line;
    variable l_ROP2_function : Std_ulogic_vector(2 downto 0);
    variable l_ROP2_in_A, l_ROP2_in_B, l_ROP2_in_C, l_ROP2_out : F_VECTOR;
    variable l_ROP2_mode : Std_ulogic_vector(1 downto 0);

    function combine_and (
      data : F_VECTOR)
    return F_VECTOR is                                -- Std_ulogic_vector is
      variable t : F_VECTOR := (others => '0');
      variable i : natural;
    begin
      for i in 0 to MAXSIZE-1 loop
        if data((i*8)+7 downto i*8)  = X"FF" then
              t((i*8)+7 downto i*8) := X"FF";
        end if;
      end loop;  -- i
      return t;
    end;

    function combine_or (
      data : F_VECTOR)
    return Std_ulogic_vector is
      variable t : F_VECTOR := (others => '0');
      variable i : natural;
    begin
      for i in 0 to MAXSIZE-1 loop
        if data((i*8)+7 downto i*8) /= X"00" then
              t((i*8)+7 downto i*8) := X"FF";
        end if;
      end loop;  -- i
      return t;
    end;

    procedure write_vector (
      expected_value : F_VECTOR) is
    begin
      owrite(lout, l_ROP2_function);
       write(lout, ' ');
      owrite(lout, l_ROP2_mode);
       write(lout, ' ');
      hwrite(lout, l_ROP2_in_A);
       write(lout, ' ');
      hwrite(lout, l_ROP2_in_B);
       write(lout, ' ');
      hwrite(lout, l_ROP2_in_C);
       write(lout, ' ');
      hwrite(lout, expected_value);
       writeline(stimulus, lout);
    end write_vector;

    procedure all_modes(
      f : Std_ulogic_vector(2 downto 0);
      expected_value : F_VECTOR) is
    begin
      l_ROP2_function := f;
      l_ROP2_mode := ROP2_DIRECT_MODE;
      write_vector(expected_value);
      l_ROP2_mode := ROP2_AND_MODE;
      write_vector(combine_and(expected_value));
      l_ROP2_mode := ROP2_OR_MODE;
      write_vector(combine_or(expected_value));
    end all_modes;

    procedure all_functions is
    begin

-- break this glas in case of emergency :
--      writeline(output, lout);
--      write(lout, string'("A = "));
--      write(lout, l_ROP2_in_A);
--      writeline(output, lout);
--      write(lout, string'("B = "));
--      write(lout, l_ROP2_in_B);
--      writeline(output, lout);
--      write(lout, string'("C = "));
--      write(lout, l_ROP2_in_C);
--      writeline(output, lout);

      -- the MUX
      l_ROP2_mode := ROP2_MUX_MODE;
      l_ROP2_function := rand_vector(l_ROP2_function);
      write_vector((l_ROP2_in_C  and l_ROP2_in_B)
            or (not(l_ROP2_in_C) and l_ROP2_in_A));

      -- the other modes
      all_modes(ROP2_AND ,     l_ROP2_in_A and     l_ROP2_in_B);
      all_modes(ROP2_ANDN,     l_ROP2_in_A and not(l_ROP2_in_B));
      all_modes(ROP2_XOR ,     l_ROP2_in_A xor     l_ROP2_in_B);
      all_modes(ROP2_OR  ,     l_ROP2_in_A or      l_ROP2_in_B);
      all_modes(ROP2_NOR , not(l_ROP2_in_A or      l_ROP2_in_B));
      all_modes(ROP2_XNOR, not(l_ROP2_in_A xor     l_ROP2_in_B));
      all_modes(ROP2_ORN ,     l_ROP2_in_A or  not(l_ROP2_in_B));
      all_modes(ROP2_NAND, not(l_ROP2_in_A and     l_ROP2_in_B));
    end all_functions;

  begin

    l_ROP2_in_A := X"5555555555555555";
    l_ROP2_in_B := X"3333333333333333";
    l_ROP2_in_C := X"FEDCBA9876543210";
    all_functions;

    for a in 0 to 1 loop
      l_ROP2_in_A := F_VECTOR'(others => std_ulogic'val(a));
      for b in 0 to 1 loop
        l_ROP2_in_B := F_VECTOR'(others => (b));
        for c in 0 to 1 loop
          l_ROP2_in_C := F_VECTOR'(others => c));
          all_functions;
        end loop;  -- c
      end loop;  -- b
    end loop;  -- a

    for k in 1 to 20 loop 
      l_ROP2_in_A := rand_vector(l_ROP2_in_A);
      l_ROP2_in_B := rand_vector(l_ROP2_in_B);  -- sorry, no time to do something else.
      l_ROP2_in_C := rand_vector(l_ROP2_in_C);
      all_functions;
    end loop;  -- k

    wait;  -- stop the simulation counter.
  end process;

end;   --  arch1 of test_rop2
