#! /bin/bash

#  ncsim.sh
#  created sam mar  9 22:26:11 GMT 2002 from f-cpu/vhdl/eu_rop2/vanilla.sh
#  initial mar dec  4 19:27:41 GMT 2001 by whygee@f-cpu.org
#  version ven dec 14 01:40:24 GMT 2001
#  
#  little bash script that compiles and tests the example units


# some cut&paste from /etc/init.d/functions
RES_COL=20
MOVE_TO_COL="echo -en \\033[${RES_COL}G"
SETCOLOR_SUCCESS="echo -en \\033[1;32m"
SETCOLOR_FAILURE="echo -en \\033[1;31m"
SETCOLOR_WARNING="echo -en \\033[1;33m"
SETCOLOR_NORMAL="echo -en \\033[0;39m"

echo_success() {
  $MOVE_TO_COL
  echo -n "[ "
  $SETCOLOR_SUCCESS
  echo -n $*
  $SETCOLOR_NORMAL
  echo -n " ]"
  echo -ne "\r"
  echo
  return 0
}

# verifications :

if [ ! -d cds_work_dir ] ; then
  mkdir cds_work_dir
fi

if [ ! -e cds.lib ] ; then
  ln -s ../cds.lib cds.lib
fi

if [ ! -e hdl.var ] ; then
  ln -s ../hdl.var hdl.var
fi

# usually takes the lib.entity:arch address.
function simulate ()
{
  ncelab $*  &&
  ncsim $*   &&
  echo_success $*
}

# Only the "clear" function works with ncsim now :-/
ncvhdl -V93 ../common/fanout.vhdl ../common/test_fanout.vhdl ../common/random.vhdl ../common/random_clear.vhdl &&
simulate work.test_fanout:arch1 &&
#ncvhdl -V93 ../common/fanout_linear.vhdl &&
#simulate work.test_fanout &&
ncvhdl -V93 ../configuration/f-cpu_config.vhdl rop2_unit.vhdl  rop2_xbar.vhdl test_rop2.vhdl &&
simulate work.test_rop2:arch1
