--------------------------------------------------------------------------
-- File vhdl/eu_inc/bloc_and.vhdl - Base block for find LSB
-- Copyright (C) 2002 Etienne Labarre (etienne.labarre@gadz.org)
--
-- Tue Jun  4 18:20:46 CEST 2002
--
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
--------------------------------------------------------------------------

-- include standard libraries
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.all;

-- Definition of bloc_and entity
entity bloc_and is
   port (
      input  : in  std_ulogic_vector(3 downto 0);
      output : out std_ulogic_vector(3 downto 0);
      carry  : out std_ulogic
      );
end bloc_and;


-- Description of bloc_and entity
architecture simple of bloc_and is

begin
   output(0) <= input(0);
   output(1) <= input(0) and input(1);
   output(2) <= input(0) and input(1) and input(2);
   output(3) <= input(0) and input(1) and input(2) and input(3);
   carry     <= input(0) and input(1) and input(2) and input(3);
end;
