-------------------------------------------------------------------------------
-- Title      : substraction component
-- Project    : F-CPU divmod unit
-------------------------------------------------------------------------------
-- File       : substraction.vhdl
-- Author     : Cedric  <bail_c@epita.fr>
-- Company    : 
-- Last update: 2002/01/08
-- Platform   : 
-------------------------------------------------------------------------------
-- Description: substraction package for division component
--      If you want a quick division, ehance this.
-------------------------------------------------------------------------------
-- Revisions  :
-- Date        Version  Author  Description
-- 2001/11/29  1.0      bail_c	Created
-------------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;

entity substractor is
  
  port (
    A      : in  std_ulogic_vector(3 downto 0);
    B      : in  std_ulogic_vector(3 downto 0);
    R      : in  std_ulogic;
    result : out std_ulogic_vector(4 downto 0));

end substractor;

architecture cb of substractor is
  subtype NineBits is std_ulogic_vector (8 downto 0);
begin  -- cb

  with NineBits'(R & B & A) select
    result <=
    "00000" when "000010001",
    "00000" when "000100010",
    "00000" when "000110011",
    "00000" when "001000100",
    "00000" when "001010101",
    "00000" when "001100110",
    "00000" when "001110111",
    "00000" when "010001000",
    "00000" when "010011001",
    "00000" when "010101010",
    "00000" when "010111011",
    "00000" when "011001100",
    "00000" when "011011101",
    "00000" when "011101110",
    "00000" when "011111111",
    "00000" when "100000001",
    "00000" when "100010010",
    "00000" when "100100011",
    "00000" when "100110100",
    "00000" when "101000101",
    "00000" when "101010110",
    "00000" when "101100111",
    "00000" when "101111000",
    "00000" when "110001001",
    "00000" when "110011010",
    "00000" when "110101011",
    "00000" when "110111100",
    "00000" when "111001101",
    "00000" when "111011110",
    "00000" when "111101111",
    "00000" when "000000000",
    "00001" when "000000001",
    "00001" when "000010010",
    "00001" when "000100011",
    "00001" when "000110100",
    "00001" when "001000101",
    "00001" when "001010110",
    "00001" when "001100111",
    "00001" when "001111000",
    "00001" when "010001001",
    "00001" when "010011010",
    "00001" when "010101011",
    "00001" when "010111100",
    "00001" when "011001101",
    "00001" when "011011110",
    "00001" when "011101111",
    "00001" when "100000010",
    "00001" when "100010011",
    "00001" when "100100100",
    "00001" when "100110101",
    "00001" when "101000110",
    "00001" when "101010111",
    "00001" when "101101000",
    "00001" when "101111001",
    "00001" when "110001010",
    "00001" when "110011011",
    "00001" when "110101100",
    "00001" when "110111101",
    "00001" when "111001110",
    "00001" when "111011111",
    "00010" when "000000010",
    "00010" when "000010011",
    "00010" when "000100100",
    "00010" when "000110101",
    "00010" when "001000110",
    "00010" when "001010111",
    "00010" when "001101000",
    "00010" when "001111001",
    "00010" when "010001010",
    "00010" when "010011011",
    "00010" when "010101100",
    "00010" when "010111101",
    "00010" when "011001110",
    "00010" when "011011111",
    "00010" when "100000011",
    "00010" when "100010100",
    "00010" when "100100101",
    "00010" when "100110110",
    "00010" when "101000111",
    "00010" when "101011000",
    "00010" when "101101001",
    "00010" when "101111010",
    "00010" when "110001011",
    "00010" when "110011100",
    "00010" when "110101101",
    "00010" when "110111110",
    "00010" when "111001111",
    "00011" when "000000011",
    "00011" when "000010100",
    "00011" when "000100101",
    "00011" when "000110110",
    "00011" when "001000111",
    "00011" when "001011000",
    "00011" when "001101001",
    "00011" when "001111010",
    "00011" when "010001011",
    "00011" when "010011100",
    "00011" when "010101101",
    "00011" when "010111110",
    "00011" when "011001111",
    "00011" when "100000100",
    "00011" when "100010101",
    "00011" when "100100110",
    "00011" when "100110111",
    "00011" when "101001000",
    "00011" when "101011001",
    "00011" when "101101010",
    "00011" when "101111011",
    "00011" when "110001100",
    "00011" when "110011101",
    "00011" when "110101110",
    "00011" when "110111111",
    "00100" when "000000100",
    "00100" when "000010101",
    "00100" when "000100110",
    "00100" when "000110111",
    "00100" when "001001000",
    "00100" when "001011001",
    "00100" when "001101010",
    "00100" when "001111011",
    "00100" when "010001100",
    "00100" when "010011101",
    "00100" when "010101110",
    "00100" when "010111111",
    "00100" when "100000101",
    "00100" when "100010110",
    "00100" when "100100111",
    "00100" when "100111000",
    "00100" when "101001001",
    "00100" when "101011010",
    "00100" when "101101011",
    "00100" when "101111100",
    "00100" when "110001101",
    "00100" when "110011110",
    "00100" when "110101111",
    "00101" when "000000101",
    "00101" when "000010110",
    "00101" when "000100111",
    "00101" when "000111000",
    "00101" when "001001001",
    "00101" when "001011010",
    "00101" when "001101011",
    "00101" when "001111100",
    "00101" when "010001101",
    "00101" when "010011110",
    "00101" when "010101111",
    "00101" when "100000110",
    "00101" when "100010111",
    "00101" when "100101000",
    "00101" when "100111001",
    "00101" when "101001010",
    "00101" when "101011011",
    "00101" when "101101100",
    "00101" when "101111101",
    "00101" when "110001110",
    "00101" when "110011111",
    "00110" when "000000110",
    "00110" when "000010111",
    "00110" when "000101000",
    "00110" when "000111001",
    "00110" when "001001010",
    "00110" when "001011011",
    "00110" when "001101100",
    "00110" when "001111101",
    "00110" when "010001110",
    "00110" when "010011111",
    "00110" when "100000111",
    "00110" when "100011000",
    "00110" when "100101001",
    "00110" when "100111010",
    "00110" when "101001011",
    "00110" when "101011100",
    "00110" when "101101101",
    "00110" when "101111110",
    "00110" when "110001111",
    "00111" when "000000111",
    "00111" when "000011000",
    "00111" when "000101001",
    "00111" when "000111010",
    "00111" when "001001011",
    "00111" when "001011100",
    "00111" when "001101101",
    "00111" when "001111110",
    "00111" when "010001111",
    "00111" when "100001000",
    "00111" when "100011001",
    "00111" when "100101010",
    "00111" when "100111011",
    "00111" when "101001100",
    "00111" when "101011101",
    "00111" when "101101110",
    "00111" when "101111111",
    "01000" when "000001000",
    "01000" when "000011001",
    "01000" when "000101010",
    "01000" when "000111011",
    "01000" when "001001100",
    "01000" when "001011101",
    "01000" when "001101110",
    "01000" when "001111111",
    "01000" when "100001001",
    "01000" when "100011010",
    "01000" when "100101011",
    "01000" when "100111100",
    "01000" when "101001101",
    "01000" when "101011110",
    "01000" when "101101111",
    "01001" when "000001001",
    "01001" when "000011010",
    "01001" when "000101011",
    "01001" when "000111100",
    "01001" when "001001101",
    "01001" when "001011110",
    "01001" when "001101111",
    "01001" when "100001010",
    "01001" when "100011011",
    "01001" when "100101100",
    "01001" when "100111101",
    "01001" when "101001110",
    "01001" when "101011111",
    "01010" when "000001010",
    "01010" when "000011011",
    "01010" when "000101100",
    "01010" when "000111101",
    "01010" when "001001110",
    "01010" when "001011111",
    "01010" when "100001011",
    "01010" when "100011100",
    "01010" when "100101101",
    "01010" when "100111110",
    "01010" when "101001111",
    "01011" when "000001011",
    "01011" when "000011100",
    "01011" when "000101101",
    "01011" when "000111110",
    "01011" when "001001111",
    "01011" when "100001100",
    "01011" when "100011101",
    "01011" when "100101110",
    "01011" when "100111111",
    "01100" when "000001100",
    "01100" when "000011101",
    "01100" when "000101110",
    "01100" when "000111111",
    "01100" when "100001101",
    "01100" when "100011110",
    "01100" when "100101111",
    "01101" when "000001101",
    "01101" when "000011110",
    "01101" when "000101111",
    "01101" when "100001110",
    "01101" when "100011111",
    "01110" when "000001110",
    "01110" when "000011111",
    "01110" when "100001111",
    "01111" when "000001111",
    "10000" when "111110000",
    "10001" when "011110000",
    "10001" when "111100000",
    "10001" when "111110001",
    "10010" when "011100000",
    "10010" when "011110001",
    "10010" when "111010000",
    "10010" when "111100001",
    "10010" when "111110010",
    "10011" when "011010000",
    "10011" when "011100001",
    "10011" when "011110010",
    "10011" when "111000000",
    "10011" when "111010001",
    "10011" when "111100010",
    "10011" when "111110011",
    "10100" when "011000000",
    "10100" when "011010001",
    "10100" when "011100010",
    "10100" when "011110011",
    "10100" when "110110000",
    "10100" when "111000001",
    "10100" when "111010010",
    "10100" when "111100011",
    "10100" when "111110100",
    "10101" when "010110000",
    "10101" when "011000001",
    "10101" when "011010010",
    "10101" when "011100011",
    "10101" when "011110100",
    "10101" when "110100000",
    "10101" when "110110001",
    "10101" when "111000010",
    "10101" when "111010011",
    "10101" when "111100100",
    "10101" when "111110101",
    "10110" when "010100000",
    "10110" when "010110001",
    "10110" when "011000010",
    "10110" when "011010011",
    "10110" when "011100100",
    "10110" when "011110101",
    "10110" when "110010000",
    "10110" when "110100001",
    "10110" when "110110010",
    "10110" when "111000011",
    "10110" when "111010100",
    "10110" when "111100101",
    "10110" when "111110110",
    "10111" when "010010000",
    "10111" when "010100001",
    "10111" when "010110010",
    "10111" when "011000011",
    "10111" when "011010100",
    "10111" when "011100101",
    "10111" when "011110110",
    "10111" when "110000000",
    "10111" when "110010001",
    "10111" when "110100010",
    "10111" when "110110011",
    "10111" when "111000100",
    "10111" when "111010101",
    "10111" when "111100110",
    "10111" when "111110111",
    "11000" when "010000000",
    "11000" when "010010001",
    "11000" when "010100010",
    "11000" when "010110011",
    "11000" when "011000100",
    "11000" when "011010101",
    "11000" when "011100110",
    "11000" when "011110111",
    "11000" when "101110000",
    "11000" when "110000001",
    "11000" when "110010010",
    "11000" when "110100011",
    "11000" when "110110100",
    "11000" when "111000101",
    "11000" when "111010110",
    "11000" when "111100111",
    "11000" when "111111000",
    "11001" when "001110000",
    "11001" when "010000001",
    "11001" when "010010010",
    "11001" when "010100011",
    "11001" when "010110100",
    "11001" when "011000101",
    "11001" when "011010110",
    "11001" when "011100111",
    "11001" when "011111000",
    "11001" when "101100000",
    "11001" when "101110001",
    "11001" when "110000010",
    "11001" when "110010011",
    "11001" when "110100100",
    "11001" when "110110101",
    "11001" when "111000110",
    "11001" when "111010111",
    "11001" when "111101000",
    "11001" when "111111001",
    "11010" when "001100000",
    "11010" when "001110001",
    "11010" when "010000010",
    "11010" when "010010011",
    "11010" when "010100100",
    "11010" when "010110101",
    "11010" when "011000110",
    "11010" when "011010111",
    "11010" when "011101000",
    "11010" when "011111001",
    "11010" when "101010000",
    "11010" when "101100001",
    "11010" when "101110010",
    "11010" when "110000011",
    "11010" when "110010100",
    "11010" when "110100101",
    "11010" when "110110110",
    "11010" when "111000111",
    "11010" when "111011000",
    "11010" when "111101001",
    "11010" when "111111010",
    "11011" when "001010000",
    "11011" when "001100001",
    "11011" when "001110010",
    "11011" when "010000011",
    "11011" when "010010100",
    "11011" when "010100101",
    "11011" when "010110110",
    "11011" when "011000111",
    "11011" when "011011000",
    "11011" when "011101001",
    "11011" when "011111010",
    "11011" when "101000000",
    "11011" when "101010001",
    "11011" when "101100010",
    "11011" when "101110011",
    "11011" when "110000100",
    "11011" when "110010101",
    "11011" when "110100110",
    "11011" when "110110111",
    "11011" when "111001000",
    "11011" when "111011001",
    "11011" when "111101010",
    "11011" when "111111011",
    "11100" when "001000000",
    "11100" when "001010001",
    "11100" when "001100010",
    "11100" when "001110011",
    "11100" when "010000100",
    "11100" when "010010101",
    "11100" when "010100110",
    "11100" when "010110111",
    "11100" when "011001000",
    "11100" when "011011001",
    "11100" when "011101010",
    "11100" when "011111011",
    "11100" when "100110000",
    "11100" when "101000001",
    "11100" when "101010010",
    "11100" when "101100011",
    "11100" when "101110100",
    "11100" when "110000101",
    "11100" when "110010110",
    "11100" when "110100111",
    "11100" when "110111000",
    "11100" when "111001001",
    "11100" when "111011010",
    "11100" when "111101011",
    "11100" when "111111100",
    "11101" when "000110000",
    "11101" when "001000001",
    "11101" when "001010010",
    "11101" when "001100011",
    "11101" when "001110100",
    "11101" when "010000101",
    "11101" when "010010110",
    "11101" when "010100111",
    "11101" when "010111000",
    "11101" when "011001001",
    "11101" when "011011010",
    "11101" when "011101011",
    "11101" when "011111100",
    "11101" when "100100000",
    "11101" when "100110001",
    "11101" when "101000010",
    "11101" when "101010011",
    "11101" when "101100100",
    "11101" when "101110101",
    "11101" when "110000110",
    "11101" when "110010111",
    "11101" when "110101000",
    "11101" when "110111001",
    "11101" when "111001010",
    "11101" when "111011011",
    "11101" when "111101100",
    "11101" when "111111101",
    "11110" when "000100000",
    "11110" when "000110001",
    "11110" when "001000010",
    "11110" when "001010011",
    "11110" when "001100100",
    "11110" when "001110101",
    "11110" when "010000110",
    "11110" when "010010111",
    "11110" when "010101000",
    "11110" when "010111001",
    "11110" when "011001010",
    "11110" when "011011011",
    "11110" when "011101100",
    "11110" when "011111101",
    "11110" when "100010000",
    "11110" when "100100001",
    "11110" when "100110010",
    "11110" when "101000011",
    "11110" when "101010100",
    "11110" when "101100101",
    "11110" when "101110110",
    "11110" when "110000111",
    "11110" when "110011000",
    "11110" when "110101001",
    "11110" when "110111010",
    "11110" when "111001011",
    "11110" when "111011100",
    "11110" when "111101101",
    "11110" when "111111110",
    "11111" when "000010000",
    "11111" when "000100001",
    "11111" when "000110010",
    "11111" when "001000011",
    "11111" when "001010100",
    "11111" when "001100101",
    "11111" when "001110110",
    "11111" when "010000111",
    "11111" when "010011000",
    "11111" when "010101001",
    "11111" when "010111010",
    "11111" when "011001011",
    "11111" when "011011100",
    "11111" when "011101101",
    "11111" when "011111110",
    "11111" when "100000000",
    "11111" when "100010001",
    "11111" when "100100010",
    "11111" when "100110011",
    "11111" when "101000100",
    "11111" when "101010101",
    "11111" when "101100110",
    "11111" when "101110111",
    "11111" when "110001000",
    "11111" when "110011001",
    "11111" when "110101010",
    "11111" when "110111011",
    "11111" when "111001100",
    "11111" when "111011101",
    "11111" when "111101110",
    "11111" when "111111111",
    NULL when others;

end cb;
