-------------------------------------------------------------------------------
-- Title      : test bench for divmods
-- Project    : F-CPU
-------------------------------------------------------------------------------
-- File       : divmodstest.vhdl
-- Author     : cedric bail  <bail_c@tuxy>
-- Company    : 
-- Last update: 2002/01/04
-- Platform   : 
-- Licence    : GPL 2.0 or newer
-------------------------------------------------------------------------------
-- Description: an easy test bench
-------------------------------------------------------------------------------
-- Revisions  :
-- Date        Version  Author  Description
-- 2001/11/30  1.0      bail_c	Created
-------------------------------------------------------------------------------

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_textio.all;
use IEEE.numeric_std.all;
use std.textio.all;

entity IDivmods_Test is
  
end IDivmods_Test;

architecture cb of IDivmods_Test is
  component divmods
    generic (
      WIDTH     : natural;
      PIPELINED : boolean);
    port (
      A  : in  std_ulogic_vector(WIDTH-1 downto 0);
      B  : in  std_ulogic_vector(WIDTH-1 downto 0);
      Start : in std_ulogic := '0';
      Clk, Reset : in std_ulogic := '1';
      Freeze : in std_ulogic := '0';
      Yl : out std_ulogic_vector(WIDTH-1 downto 0);
      Yh : out std_ulogic_vector(WIDTH-1 downto 0);
      WillBe : out std_ulogic;
      Ready : out std_ulogic);
  end component;

  for all : divmods use entity work.divmods(final8_cb);
--  for all : divmods use entity work.divmods(cb_jumpA0);
--  for all : divmods use entity work.divmods(cb_jumpB0);

  constant WIDTH : natural := 8;

  signal A, B, Yl, Yh : std_ulogic_vector(WIDTH-1 downto 0) := (others => '0');
  signal Start, Ready, WillBe : std_ulogic;
  signal Clk, Reset, Freeze : std_ulogic := '0';
  
  procedure writestr (s : string) is
    variable lout : line;
  begin
    write(lout, s);
    writeline(output, lout);
  end writestr;

  procedure do_report (lbl : string;
                       x, y : std_ulogic_vector) is
    variable lout : line;
  begin
    write(lout, string'("WHOA THERE!!!")); writeline(output, lout);
    write(lout, string'("A := ")); write(lout, A); writeline(output, lout);
    write(lout, string'("B := ")); write(lout, B); writeline(output, lout);
    write(lout, lbl);
    write(lout, string'(" := "));
    write(lout, x);
    writeline(output, lout);
    write(lout, lbl);
    write(lout, string'(" /= "));
    write(lout, y);
    writeline(output, lout);
  end do_report;

  procedure check_numeric (lbl : string;
                           x : std_ulogic_vector;
                           y : natural) is
    variable tmp : std_ulogic_vector(x'range);
    variable lout : line;
  begin
    tmp := std_ulogic_vector(
      to_unsigned(y mod 2**x'length, x'length));
    if x /= tmp then
      do_report(lbl, x, tmp);
    end if;
  end check_numeric;

begin
  to_test : divmods generic map (
    WIDTH     => WIDTH,
    PIPELINED => false)
    port map (
      A  => A,
      B  => B,
      Start => Start,
      Clk => Clk,
      Reset => Reset,
      Freeze => Freeze,
      Yl => Yl,
      Yh => Yh,
      Ready => Ready,
      WillBe => WillBe);

  -- purpose: test divmods
  test: process
    variable res : natural;

    variable lout : line;
  begin  -- process test
    writestr("*** Testing diviser base component ***");
    Start <= '0';
    for i in 0 to (2 ** WIDTH)-1 loop
      for j in 1 to (2 ** WIDTH)-1 loop
        A <= std_ulogic_vector(to_unsigned(i, WIDTH));
        B <= std_ulogic_vector(to_unsigned(j, WIDTH));
        Start <= '1';
        for k in 0 to WIDTH loop
          Clk <= '1';
          wait for 1 ns;
          Clk <= '0';
          wait for 1 ns;
        end loop;  -- i
--        wait on Ready until Ready = '1';
        res := i / j;
        check_numeric("Yl", Yl, res);
        res := i mod j;
        check_numeric("Yh", Yh, res);
        Start <= '0';
        Clk <= '0';
      end loop;  -- j
    end loop;  -- i
    writestr("*** Test complete ***");
    wait;
  end process test;
end cb;
