# YG's small dirty script for compiling the FC0 with Simili under wine
# created Sat Sep  8 04:15:12 2001
# updated Fri Sep 14 07:42:49 2001 : added the array of filenames

# check if the detection is already performed :
if [ -f tools.env ]
then
    . tools.env
else
    . tool_configure.sh
fi

# check the result
if [ "$SIMILI_WINE" == "" ]
then
    echo " # could not run Simili : aborting."
    exit 1
fi


#these strings are formed with the rule : directory_name=(file1 file2 file_n)
   configuration=(f-cpu_config.vhdl f-cpu_opcodes.vhdl clock_config.vhdl)
          common=(generic_adder.vhdl random.vhdl)
         eu_rop2=(rop2_xbar.vhdl rop2_unit.vhdl)

# list of the directory names
     directories=(configuration common eu_rop2)

#concatenation of everything :
for j in ${directories[@]}    # scan all the directory names
do
    k=$j[@] # <=there's a trick here
    for l in ${!k} # <= indirection !  scan all the file names
    do
	files="$files $j/$l" # concatenation
    done
done

#run the tool with all the files in the command line
# (avoids the latency time from wine's setup)
wine -debugmsg -all "vhdlp -nostderr -s -strict $files"
