#!/bin/bash

# f-cpu/vhdl/common/test.sh
# created Mon Jun 24 02:25:59 CEST 2002 by whygee@f-cpu.org
# This is a first example that is used to test all the
# files of this directory.
# updated Sat Jun 29 04:34:11 CEST 2002 : added $EXHAUSTIVE_TEST

source ../tools.desc/vhdl_tools.sh &&

function loop_tools () {
  for LOOP_TOOL in $BACK_TOOLS
  do
    VHDL_TOOLNAMES=$LOOP_TOOL
    vhdl_compile &&
    diff in out || return 1
  done
}

(
  # testing raw binary file I/Os :
  ENTITY=cat
  ARCHITECTURE=tst
  FILENAMELIST=cat.vhdl    
  BACK_TOOLS=$VHDL_TOOLNAMES
  rm -f simili_binary_ok.touch in out
  dd if=/dev/urandom of=in bs=1k count=10 &&
  mv $TOOLNAMES_FILE .vhdl_tool.back &&
  loop_tools &&
  rm -f in out &&
  mv .vhdl_tool.back $TOOLNAMES_FILE &&
  echo_success binary I/O is ok.
) && (
  # testing the random package :
  FILENAMELIST="random_simple.vhdl test_rand.vhdl"
  ENTITY=test_rand
  ARCHITECTURE=test
  vhdl_compile &&
  echo_success "The random package is ok"
) && (
  # testing the fanout entity
  FILENAMELIST="fanout.vhdl test_fanout.vhdl"
  ENTITY=test_fanout
  ARCHITECTURE=arch1
  vhdl_compile &&
  FILENAMELIST="fanout_linear.vhdl" &&
  vhdl_compile &&
  echo_success "fanout : ok"
) && (
  # testing Michael's packages :
  if [ -n "$EXHAUSTIVE_TEST" ]
  then
    echo_failure "Warning : the following tests can last several minutes !"
    FILENAMELIST="misc.vhdl bit_manipulation.vhdl bit_manipulation_test.vhdl"
    ENTITY=Bit_Manipulation_test
    ARCHITECTURE=arch_1
    vhdl_compile &&
    FILENAMELIST="generic_adder.vhdl generic_adder_test.vhdl" &&
    ENTITY=generic_adder_test &&
    vhdl_compile
  else
    FILENAMELIST="misc.vhdl bit_manipulation.vhdl bit_manipulation_test.vhdl generic_adder.vhdl generic_adder_test.vhdl"
    unset ENTITY
    unset ARCHITECTURE
    vhdl_compile
  fi &&
  echo_success "MR's files are ok"
) || echo_failure "oooops..."
