--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
--------------------------BEGIN-VHDL-LICENSE-----------------------------
--
-- package body : random_clear
-- created Wed Sep 12 03:18:00 2001 by whygee@f-cpu.org
-- version dim dec 30 06:53:25 2001 : split body and declaration.
--
-- This package is used as a replacement if you can't use
-- the normal package "random", for example if textio is not
-- implemented or something like that (and please, _only_ in
-- such cases). It's just for convenience/failsafe.
--
-------------------------------------------------------------------------------

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE work.random.all;

package body random is

  function rand (var : in std_ulogic_vector)
    return std_ulogic_vector is
    variable t : std_ulogic_vector(var'range);
  begin
    assert random_mode /= random
      report "Random mode is not supported !"
      severity ERROR;

    if (random_mode = reset) then
      t := (others => '0');
    else
      t := (others => '1');
    end if;
    return t;
  end;

-- copy-paste of the wrappers from random_file :
  
    -- this is a "wrapper" that assumes a std_ulogic_vector(size-1 downto 0) as output.
  function rand (size : natural)
    return std_ulogic_vector is
    variable t : std_ulogic_vector(size-1 downto 0);
  begin
    t := rand(t);
    return t;
  end;

    -- this is a "wrapper" that returns a single bit.
  function rand
    return std_ulogic is
    variable t : std_ulogic_vector(0 downto 0);
  begin
    t := rand(t);   -- call the wrapped function
    return t(0);
  end;

end random;
