-- multicla.vhdl -- Multi-Output 4-Bit Carry Look-Ahead Unit
-- Copyright (C) 2000 Michael Riepe <michael@s...>
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

-- $Id: multicla.vhdl,v 1.2 2000/11/03 15:58:36 michael Exp $

library IEEE;
use IEEE.std_logic_1164.all;

entity MULTI_CLA is
        port (
                -- inputs
                Gi, Pi : in std_ulogic_vector(3 downto 0) := (others => '0');
                -- outputs
                CoNC : out std_ulogic_vector(3 downto 0);
                CoCY : out std_ulogic_vector(3 downto 0);
                Go, Po : out std_ulogic
        );
end MULTI_CLA;

architecture Behave_1 of MULTI_CLA is
begin
        CoNC <= (
                3 => Gi(2)
                  or (Pi(2) and Gi(1))
                  or (Pi(2) and Pi(1) and Gi(0)),
                2 => Gi(1)
                  or (Pi(1) and Gi(0)),
                1 => Gi(0),
                0 => '0'
        );
        CoCY <= (
                3 => Gi(2)
                  or (Pi(2) and Gi(1))
                  or (Pi(2) and Pi(1) and Gi(0))
                  or (Pi(2) and Pi(1) and Pi(0)),
                2 => Gi(1)
                  or (Pi(1) and Gi(0))
                  or (Pi(1) and Pi(0)),
                1 => Gi(0) or Pi(0),
                0 => '1'
        );
        Go <= Gi(3)
           or (Pi(3) and Gi(2))
           or (Pi(3) and Pi(2) and Gi(1))
           or (Pi(3) and Pi(2) and Pi(1) and Gi(0));
        Po <= Pi(3) and Pi(2) and Pi(1) and Pi(0);
end Behave_1;

architecture Struct_1 of MULTI_CLA is
        component AND2 is
                port (A, B : in std_ulogic; Y : out std_ulogic);
        end component;
        component AND3 is
                port (A, B, C : in std_ulogic; Y : out std_ulogic);
        end component;
        component AND4 is
                port (A, B, C, D : in std_ulogic; Y : out std_ulogic);
        end component;
        component OR2 is
                port (A, B : in std_ulogic; Y : out std_ulogic);
        end component;
        component OR3 is
                port (A, B, C : in std_ulogic; Y : out std_ulogic);
        end component;
        component OR4 is
                port (A, B, C, D : in std_ulogic; Y : out std_ulogic);
        end component;

        signal t : std_ulogic_vector(7 downto 0);
begin
        -- common terms
        tmp0 : AND2 port map (Pi(1), Gi(0), t(0));
        tmp1 : AND2 port map (Pi(2), Gi(1), t(1));
        tmp2 : AND3 port map (Pi(2), Pi(1), Gi(0), t(2));
        tmp3 : AND2 port map (Pi(1), Pi(0), t(3));
        tmp4 : AND3 port map (Pi(2), Pi(1), Pi(0), t(4));
        tmp5 : AND2 port map (Pi(3), Gi(2), t(5));
        tmp6 : AND3 port map (Pi(3), Pi(2), Gi(1), t(6));
        tmp7 : AND4 port map (Pi(3), Pi(2), Pi(1), Gi(0), t(7));

        -- outputs for Ci = '0'
        con0 : CoNC(0) <= '0';
        con1 : CoNC(1) <= Gi(0);
        con2 : OR2  port map (Gi(1), t(0), CoNC(2));
        con3 : OR3  port map (Gi(2), t(1), t(2), CoNC(3));

        -- outputs for Ci = '1'
        coc0 : CoCY(0) <= '1';
        coc1 : OR2  port map (Gi(0), Pi(0), CoCY(1));
        coc2 : OR3  port map (Gi(1), t(0), t(3), CoCY(2));
        coc3 : OR4  port map (Gi(2), t(1), t(2), t(4), CoCY(3));

        -- generate output
        gen  : OR4  port map (Gi(3), t(5), t(6), t(7), Go);

        -- propagate output
        prop : AND4 port map (Pi(3), Pi(2), Pi(1), Pi(0), Po);
end Struct_1;

-- vi: set ts=4 sw=4 : please
