--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------
--
-- f-cpu/vhdl/clock/clock_powerup.vhdl, behavioural clock generator for the FC0
-- created Wed Sep  5 04:35:14 2001 by Yann GUIDON <whygee@f-cpu.org>
-- version Fri Sep  7 09:01:17 
-- version sam dec 15 23:30:14 2001 : simple behavioural entity
-- version sam dec 29 06:37:00 2001 : renamed to clock_powerup.vhdl
--    and added the support for "soft" reset and reset_out.
-- version dim dec 30 05:50:49 2001 : YG included the clock period in the interface
--    and cleaned up things, making them work :-)
--
-- This is a nice little behavioural entity which should do the power-on
-- sequence relatively nicely. This is a one-time routine, i have not
-- implemented a "restartable" entity that supports more than one reset.
-- clock_in is ignored because it is internally generated but reset_in and
-- clock_en are used.

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
    USE ieee.std_logic_textio.all;
LIBRARY std;
    USE std.textio.ALL;
LIBRARY work;
    USE work.clock_config.ALL;  -- ../configuration/clock_config.vhdl
    USE work.clock;             -- clock.vhdl

-------------------------------------------------------------------------------
-- stand-alone behavioural clock with power-on sequence :
-------------------------------------------------------------------------------
Architecture powerup of clock is
  signal local_clk_en, local_reset : std_ulogic := '0';
begin

  -- here we constrain the internal clock and reset to setup parameters.
  clock_ok  <= clock_en and local_clk_en;
  reset_out <= reset_in and local_reset;

-------------------------------------------------------------------------------
-- the main sequence
-------------------------------------------------------------------------------
  process

    procedure display (s : string) is
      variable lout : line ;
    begin  -- display
      WRITE(lout,s);
      WRITE(lout,string'(" -- time="));
      WRITE(lout,now);
      WRITELINE(OUTPUT, lout);
    end display;
    
  begin
    -- master init
    local_clk_en <= '0';
    local_reset <= '0';

    -- power supply setup
    wait for 1 us;
    display (string'(" -- Power supply is now ok, starting the clock "));

    loop
    -- wait until the user starts the simulation
      if (clock_en /= '1') then
        wait until clock_en = '1';
      end if;
      display (string'(" -- User clock start"));

    -- start the clock
      local_clk_en <= '1';
      wait for 1 us;
      display (string'(" -- Now allowing the core to boot"));
      local_reset <= '1';

    -- wait until falling edge of clock_en
      wait until clock_en = '0';
      display (string'(" -- User clock stop"));
      local_clk_en <= '0';
      -- note : reset is not affected here. This should be fixed somehow.
    end loop;  -- rely on the clock process to stop the simulations
               -- through the exhaustion of the event list.
  end process;

-----------------------------------------------------------------------------
-- the clock process which is enabled by clk_en and local_clk_en
-----------------------------------------------------------------------------
  process
    variable clk : std_ulogic := '0';
  begin
    if (local_clk_en and clock_en) = '1' then
      clk := not clk;
      clock_out <= clk;
      wait for clock_period/2;
    else
      wait on clock_en, local_clk_en;
    end if;
  end process;

end;  -- powerup
