--------------------------BEGIN-VHDL-LICENSE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENSE------------------------------
--
-- f-cpu/vhdl/clock/clock.vhdl, clock generator for the FC0
-- created Wed Sep  5 04:35:14 2001 by Yann GUIDON <whygee@f-cpu.org>
-- version Fri Sep  7 09:01:17 
-- version sam dec 15 23:30:14 2001 : renamed from clock_vanilla.vhdl
--   and promoted to default architecture.
-- version sam dec 29 06:37:00 2001 : added some "knobs" to
--   the interface (reset_out and clock_en). Bootup procedures should
--   be simpler, now.
--
-- This is the default architecture, for use in early simulations.
-- During synthesis, the entity must be more or less rewritten for
-- the target technology. If you want to use a more complex architecture,
-- compile it after this one to replace the default architecture.

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
LIBRARY work;
    USE work.clock_config.ALL;   -- found in ../configuration/clock_config.vhdl

Entity clock is
  port(
-- external (off-core) inputs :
    reset_in,  -- circuit can operate if 1. This is a 'hard' signal.
    clock_in,  -- external clock input (can be overriden)
    clock_en : -- only for the simulations, for cleanly stopping them when going low.
      in Std_ulogic := '0';  -- the initialisation allows 'open' signals

-----------------------OPTIONAL------------------------------------------------
-- internally generated clock period :
    clock_period : time := 10 ns;
-- configuration (read from the SR) :
    clock_mode : in clock_mode_type := CLOCK_MODE_DEFAULT ;
    prediv,                      -- division factor for the external clock
    premul : std_ulogic_vector(CLOCK_COUNTER_SIZE-1 downto 0) := (others => '0');
       -- division factor for the internal clock
    NCO : std_ulogic_vector(CLOCK_NCO_SIZE-1 downto 0) := (others => '0');  -- internal clock frequency
----------------------/OPTIONAL------------------------------------------------

-- outputs :
    clock_ok,   -- it is 1 if the output frequency is OK.
    clock_out,  -- clock output for the FC0
    reset_out : out Std_ulogic   -- "soft" reset, active low.
-- warning : this is only a preliminary interface. It will be changed later.
  );
end clock;

-------------------------------------------------------------------------------
-- this one can be used to make quick tests.
-- it won't synthesise but it's helpful for debugging.
-------------------------------------------------------------------------------
Architecture dumb of clock is
begin

  -- dumb clock (with a nice on-off button)
  process
    variable clk : std_ulogic := '0';
  begin
    if clock_en = '1' then
      clk := not clk;
      clock_out <= clk;
      wait for clock_period /2;
    else
      wait on clock_en;
    end if;
  end process;

  clock_ok  <= clock_en;  -- forwards the clock enable (no delay in our simple model)
  reset_out <= reset_in;  -- allow the core to boot
end;
