/*
 * fromfs.c
 * created Wed Mar 13 22:28:26 CET 2002 by whygee@f-cpu.org
 *
 * This file describes how to use the the data structures of the
 * F-romfs file that is appended and used by whygee's boot routine.
 *
 */

/* file I/O + error messages */
#include <stdio.h>

/* memcmp */
#include <string.h>

/* for stat */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

/* custom defs */
#include "fromfs.h"

/* additional functions */
#include "fromfs_lib.c"

/* useful. */
void error(char * msg, int my_errno) {
  printf(msg);
  exit(my_errno);
}

long int fsize=0;

/*
 * load and store a whole "directory"
 */

void * load_dir(char * filename) {
  /* gets a file name, return a pointer */
  void * p;
  FILE * f;
  struct stat stat_buf;
  long int temp;

  /* fstat returns the file size and other attributes */
  temp=stat(filename,&stat_buf);
  if (temp != 0)
    error("\nError : can't find or stat() the input file\n",2);

  /* check minimak size : */
  if (stat_buf.st_size< sizeof(fromfs_header))
    error("\nError : directory is too small !",9);

  p=(void *)malloc(stat_buf.st_size);
  if (p==NULL)
    error("\nerror : can't allocate enough memory\n",3);

  /* open the file */
  f=fopen(filename,"rb");
  if (f==NULL)
    error("\nerror : can't open input file\n",4);

  /* dump it into memory */
  fsize=fread(p,1,stat_buf.st_size,f);
  if (fsize != stat_buf.st_size)
    error("\nerror while reading the input file : read aborted\n",5);

  /* PS: a mmap would have spared some code :-/ */

  return p;
}

void store_dir(char * name, void * dir) {
  /* get a pointer to a name and a fromfs base */
  
  
  free(dir);
}

  /* check the header type, size, alignment ...
     should be called after any load or before any store
     (but then, don't forget to update fsize...) */
void check_dir(void * p) {
  unsigned long int dir_size, dir_entries;
  fromfs_entry * e;
  int i;

  printf(" -- Checking consistency with FROMFS v0.1 rules --\n");

  /* just in case */
  if (p == NULL)
    error("Error : wrong base parameter\n",15);

  if (memcmp(FROMFS_SIGNATURE,p,7)!=0)
    error ("Error : unrecognized fromfs version\n",6);

  /* this will be removed when i add foreign endian support : */
  if (((fromfs_header*)p)->signature[7] != CURRENT_ENDIANNESS_CHAR)
    printf("Warning : can't read the file acurately, the endianness is not correct !\n");

  if ((unsigned long int)fsize != ((fromfs_header*)p)->dir_size)
    printf ("Warning : indicated size is not coherent with file size.\n");

  if ((((fromfs_header*)p)->dir_size & 7) !=0)
    printf ("Warning : file size is not aligned. Be careful !\n");

  /* directory entries are now checked : */
  dir_size = ((fromfs_header*)p)->dir_size;
  dir_entries = ((fromfs_header*)p)->dir_entries;
  (char *)e = p + size_fromfs_header; /* it looks so ugly :-( */

  if (dir_entries == 0)
    error("Error : no directory entry\n",10);

  if (dir_size < ( sizeof(fromfs_header) + (dir_entries*sizeof(fromfs_entry))))
    error("Error : inconsistent dir size\n",12);  

  for (i=0; i<dir_entries; i++) {

    printf("*Checking directory entry %d : %s\n",i+1,e[i].name);

    if (e[i].block_index > dir_size)
      error("Error : directory entry starts after max size\n",16);

    if ((e[i].block_index + e[i].block_size) > dir_size)
      error("Error : directory entry ends after max size\n",17);

    /* we should check the filenames, the flags and the index alignments. */
    if (e[i].name_size > 19)
      error("Error : file name is too long\n",20);

    /* we should check the filenames, the flags and the index alignments. */
    if (e[i].name_size == 0)
      error("Error : file name is zero\n",20);

    if (locate_dir(e[i].name, p) != &e[i])
      error("Error : unable to (re)locate this entry (extended name ?)\n",18);

    if ((e[i].flags & ~(FROMFS_FLAG_VALID | FROMFS_FLAG_EXEC)) != 0)
      error("Error : reserved flags are not zero\n",21);

  }
  
  printf("fromfs directory seems ok.\n");
}


int main () {
  void * base = load_dir("e.fromfs");

  check_dir(base);

  /* locate_dir("", base); */

  return 0;
}
