f-cpu/config/user.m4
created Sun Aug 19 06:34:18 2001 by whygee@f-cpu.org

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

  This file contains user-modifiable definitions
  for configuring the F-CPU core. Other specific
  definitions are specified in other files but their
  modification by the user is not recommended.
  Warning : these constants have individual types
  and limits that are loosely verified.


  This file is not specific to the FC0 and it
  will be used for other F-CPU cores. Please be
  careful about FC0-specific features. The following
  definition allows core-specific compilation,
  new values will be defined in the future.
m4_define(`__DEF_FCPU_CORE_TYPE', `1')

  F-CPU core number. remark : 0xFC0 = 4032d :-)
m4_define(`__DEF_SR_FAMILY_val',`4032')

  revision/implementation
m4_define(`__DEF_SR_STEPPING_val',`0')


  LOGMAXSIZE is the Log2 of the Size of the registers in bytes.
  Can be any integer above or equal to 3 (64-bit version).
  This is the most important parameter, the first with
  which one can play. Be careful anyway. Though it is not
  impossible, a 32-bit version will probably never work.
  "3" is currently the only working option.
m4_define(`__DEF_LOGMAXSIZE', `3')

  Please update the following field with the URL 
  of the documentation of your implementation !
  64 characters maximum.
m4_define(`__DEF_SR_URL_val', `"http://www.f-cpu.org"')


  Presence/implementation of the Execution Units
m4_define(`__DEF_EU_ROP2_PRESENT')  mandatory
m4_define (`__DEF_EU_ASU_PRESENT')   mandatory
m4_define (`__DEF_EU_SHL_PRESENT')   mandatory
m4_define (`__DEF_EU_IMUL_PRESENT')  mandatory
m4_define (`__DEF_EU_LSU_PRESENT')   mandatory
m4_define (`__DEF_EU_BIST_PRESENT')  optional
m4_define (`__DEF_EU_IDIV_PRESENT')  optional
m4_define (`__DEF_EU_INC_PRESENT')   optional
m4_define (`__DEF_EU_POPC_PRESENT')  optional
m4_define (`__DEF_EU_SRB_PRESENT')   optional
m4_define (`__DEF_EU_FADD_PRESENT')  optional
m4_define (`__DEF_EU_FMUL_PRESENT')  optional
m4_define (`__DEF_EU_FLUT_PRESENT')  optional
  These definitions serve to know what instruction
  is invalid, and what unit the user wants implemented.
  Remove the space after m4_define to activate the
  corresponding feature (if the source is available).


  now let's define FC0's memory system configuration, and particularly
  the L1 cache size (based on 256 bit cache line width) :


  L1LogLines : Log2 of the NumBer of cache Lines (MUST be EVEN)
  This parameter determines how many L1 cache lines are implemented.
  It must be >=4 and _even_ because of the particular LRU mechanism
  used for this prototype. Allowed values are 4, 6 or 8 (that is :
  16, 64 or 256 lines, or 512 bytes, 2KB or 8KB). More would correspond
  to a L2 cache... but are possible if you have enough ressources.
m4_define(`__DEF_L1LogLines',`6')

  L1ABwidth : Address Bus width, in 32-byte chuncks (32+5=128GB)
  This determines the width of the address comparator of every L1
  cache line. Be careful, too many bits might require a LOT of ressources.
  A reasonable value for a small design would be 16 (2MB of adressable
  physical memory), adapt as required. Warning : this parameter
  also determines how many address bits are physically implemented.

m4_define(`__DEF_L1ABwidth',`32')

  other fields will be made available in the future.
