/* 
  f-cpu/c/fcpusim/fcpusim.c - F-CPU simulator
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version:
           19 July 2002 13:30
    Jul 21 02:26:00 CEST 2002 JWS: extracted from old fcpusim.c
Sun Jul 21 11:02:19 CEST 2002 JWS: cganged decoder_* into: dec_*
Sun Jul 21 12:06:17 CEST 2002 JWS: added "notes" view
Sun Jul 21 16:05:09 CEST 2002 JWS: wrong keys won't couse a redraw.
Mon Jul 22 23:02:02 CEST 2002 JWS: finisched major scheduling update

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>
#include <fcpusim.h>

#include <toplevel.c>
#include <getkey.c>

#include <fetcher_view.c>
#include <decoder_view.c>
#include <registers_view.c>
#include <scheduler_view.c>
#include <xbar_view.c>
#include <eu_inc_view.c>
#include <eu_asu_view.c>
#include <notes_view.c>

void g(void){
  /* if (use_colors){ */
  printf("%c[1;33;44m",0x1B);
}

void n(void){
  /* if (use_colors){ */
  printf("%c[0;37;40m",0x1B);
}

void print_true_false( bool print_treu_false_input ){
  g();
  if ( print_treu_false_input ){
    printf("True ");
  }else{
    printf("False");
  }
  n();
}

void status_view(void){
  printf("________________________________________");
  printf("_______________________________________\n");
  printf("status after cycle ");
  g(); printf("%d" , cycle_counter); n();
  printf(" :   (during the next cycle, sch_stalled will be: ");
  print_true_false(sch_stalled);
  printf(")\n");
  if (view == "f"){ fetcher_view(); }
  if (view == "d"){ decoder_view(); }
  if (view == "r"){ registers_view(); }
  if (view == "s"){ scheduler_view(); }
  if (view == "x"){ xbar_view(); }
  if (view == "a"){ eu_asu_view(); }
  if (view == "i"){ eu_inc_view(); }
  if (view == "n"){ notes_view(); }
}

void menu(void){
  int do_next_cycle;
  int redraw;
  redraw = 1;
  do {
    if (redraw){    
      status_view();
      printf("Fetcher Decoder Registers Scheduler ");
      printf("Xbar Asu Inc enter=cycle Notes Quit ");
    }    
    c = getkey();
    printf("\n");
    do_next_cycle = 0;
    redraw = 0;
    if  (c==10 )           { do_next_cycle = 1; redraw = 1;}
    if ((c=='f')|(c=='F')) { view = "f"; redraw = 1;} /* fetcher */
    if ((c=='d')|(c=='D')) { view = "d"; redraw = 1;} /* decoder */
    if ((c=='r')|(c=='R')) { view = "r"; redraw = 1;} /* registers */
    if ((c=='s')|(c=='S')) { view = "s"; redraw = 1;} /* scheduler */
    if ((c=='x')|(c=='X')) { view = "x"; redraw = 1;} /* xbar */
    if ((c=='a')|(c=='A')) { view = "a"; redraw = 1;} /* asu */
    if ((c=='i')|(c=='I')) { view = "i"; redraw = 1;} /* inc */
    if ((c=='n')|(c=='N')) { view = "n"; redraw = 1;} /* inc */
    if ((c=='q')|(c=='Q')) { quit_fcpusim = 1; do_next_cycle = 1; }
  } while (do_next_cycle==0);
}


int main(int argc, char **argv) {

  printf("\n\n\n\n\n");
  printf("       F-CPU Simulator      (GNU General Public License)\n");
  printf(" (c) Yann GUIDON (YG) whygee@f-cpu.org\n");
  printf(" (c) Jaap Stolk (JWS) jwstolk@yahoo.com\n");
  printf(" (C) Thomas Geroudet  gertom_fcpu@yahoo.fr\n");
  printf("\n");
  printf("WARNING: only some parts work !!  read jaap.txt and source :-) \n");
  printf("\n");

  quit_fcpusim = 0;

  /* now lets see if this CPU runs! */
  cycle_counter=0;

  printf("starting BIST ...(just enter \"0\"(=NOP) for these 5 instructions)\n"); 
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  clear_all_units();
  simulate_one_cycle(); cycle_counter++;
  printf("... Done BIST.\n");

  /* fill the registers by hand, as we do not have a LOAD yet.. */
  /* (this will not take a cycle, as no cycle is simulated) */
  register_value[10] = 0x0012312312312312ll;  
  register_value[20] = 0x0001231231231231ll;  

  printf("                                  try this one: add r20,r10,r30 = 0x%8X \n",
       (OP_ADD << 24) | (10 << 12) | (20 << 6) | (30 ^ 0x01) ); 

  /* keep running !: */
  do {
    simulate_one_cycle(); cycle_counter++;
    menu();
  } while (quit_fcpusim == 0);


}
