/*
  f-cpu/c/eu_rop2/vect_rop2.c - creates tests patterns for ROP2
  created Sun Jul  7 03:07:50 CEST 2002 by Yann GUIDON (whygee@f-cpu.org)
  version Sun Jul 21 09:34:47 CEST 2002 : YG adds stimulib
  version Sun Jul 21 10:13:33 CEST 2002 : YG separated this code from test_rop2.c

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

/* defines the constants, inputs and outputs : */
#include <eu_rop2.h>

/* includes stimulib : */
#include <stimulib.c>

#define WRITE_VECTOR \
  fprintf(output_vector_handler, "%d %d %.16llX %.16llX %.16llX %.16llX\n", \
    ROP2_function, ROP2_mode, ROP2_in_A, ROP2_in_B, ROP2_in_C, expected_ROP2_out); \
  output_vector_line ++;

int main(int argc, char **argv) {
  UMAX expected_ROP2_out;
 /* unsigned int vect_count; */

  open_vector_out("vect_rop2.hex");

  ROP2_function = FUNCTION_AND;
  ROP2_mode = ROP2_AND_MODE;
  ROP2_in_A = 0x0LL;
  ROP2_in_B = 0xFFFFFFFFFFFFFFFFLL;
  ROP2_in_C = 0x0LL;
  expected_ROP2_out = 0x0LL;
  WRITE_VECTOR

  ROP2_function = FUNCTION_ANDN;
  WRITE_VECTOR

  ROP2_function = FUNCTION_OR;
  expected_ROP2_out = 0xFFFFFFFFFFFFFFFFLL;
  WRITE_VECTOR

  close_vector_out();

/*
  u8 mode, function, i;

  ROP2_in_A = 0x0123456789ABCDEFLL;
  ROP2_in_B = 0x2435465768798098LL;
  ROP2_in_C = 0xFEDCBA9876543210LL;

  for (i=0; i<64; i++) {
    for (function=0; function<=7; function++) {
      ROP2_function=function;
      printf ("function=%d\n",function);
      for (mode=3; mode!=0; mode--) {
        ROP2_mode=mode;
        cycle_rop2 ();
        cycle_rop2 ();
        printf("mode=%d, out=%16llX\n", mode, ROP2_out);
      }
    }
    ROP2_in_B ^= ROP2_in_A; 
    ROP2_in_A = (ROP2_in_A >> 1) + ROP2_out;
  }
*/

  return 0;
}
