/*
  f-cpu/c/eu_rop2/eu_rop2.c - ROP2 Execution Unit for the F-CPU
  Copyright (C) 2000-2002 Yann GUIDON (whygee@f-cpu.org)
  version Sun Jul  7 00:40:35 CEST 2002 : very dumb, lacks global definitions
  version Sun Jul 21 10:32:00 CEST 2002 : a bit better...

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------

*/

/* defines the constants, inputs and outputs : */
#include <eu_rop2.h>

static inline void cycle_rop2 (void) {

  UMAX ROP2_result;

  /* the ROP2 cycle */
  if (ROP2_mode == ROP2_MUX_MODE) {
    ROP2_out = ( ROP2_in_A &  ROP2_in_C )
             | ( ROP2_in_B & ~ROP2_in_C );
  }
  else {
    switch (tmp_ROP2_function) {
      case FUNCTION_AND:  ROP2_result =   ROP2_in_A &  ROP2_in_B;  break;
      case FUNCTION_ANDN: ROP2_result =   ROP2_in_A & ~ROP2_in_B;  break;
      case FUNCTION_XOR:  ROP2_result =   ROP2_in_A ^  ROP2_in_B;  break;
      case FUNCTION_OR:   ROP2_result =   ROP2_in_A |  ROP2_in_B;  break;
      case FUNCTION_NOR:  ROP2_result = ~(ROP2_in_A |  ROP2_in_B); break;
      case FUNCTION_XNOR: ROP2_result = ~(ROP2_in_A ^  ROP2_in_B); break;
      case FUNCTION_ORN:  ROP2_result =   ROP2_in_A | ~ROP2_in_B;  break;
      case FUNCTION_NAND: ROP2_result = ~(ROP2_in_A &  ROP2_in_B); break;
    }

    if (ROP2_mode == ROP2_OR_MODE) {
      /* OR combination : */
      ROP2_result |= ROP2_result >> 1;
      ROP2_result |= ROP2_result >> 2;
      ROP2_result |= ROP2_result >> 4;
    }
    if (ROP2_mode == ROP2_AND_MODE) {
      /* AND combination : */
      ROP2_result &= ROP2_result >> 1;
      ROP2_result &= ROP2_result >> 2;
      ROP2_result &= ROP2_result >> 4;
    }
    if (ROP2_mode != ROP2_DIRECT_MODE) {
      /* mask useless bits out */
      ROP2_result &= 0x0101010101010101LL;
      /* expand the bit result to a byte */
      ROP2_result |= ROP2_result << 1;
      ROP2_result |= ROP2_result << 2;
      ROP2_result |= ROP2_result << 4;
    }

    ROP2_out = ROP2_result;
  }

  /* the Xbar cycle */
  tmp_ROP2_function = ROP2_function;
}
