/*
  f-cpu/c/eu_inc/test_inc.c - tests the ASU Execution Unit
  Copyright (C) 2002 Jaap Stolk (JWS) jwstolk@yahoo.com
  version: 19 July 2002 13:30

 ------------------------BEGIN-LICENSE------------------------------------
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ---------------------------END-LICENSE-----------------------------------
*/

#include <stdio.h>
#include <eu_asu.c>

int main(int argc, char **argv) {

  printf("42 bit ADD test:\n");
  ASU_in_A    = 0x0123456789ABCDEFLL;  
  ASU_in_B    = 0x0000011111111111LL;
  ASU_ADD     = true;
  ASU_SUB     = false;
  ASU_wrcarry = false;
  ASU_simd    = false;
  ASU_size    = SIMD_MAX;
  cycle_asu ();
  cycle_asu ();
  printf("ASU_out=%16llX\n", ASU_out);

  printf("8 bit SUB test:\n");
  ASU_in_A    = 0x0000000000000034LL;  
  ASU_in_B    = 0x0000000000000012LL;
  ASU_ADD     = false;
  ASU_SUB     = true;
  ASU_wrcarry = false;
  ASU_simd    = false;
  ASU_size    = SIMD_8;
  cycle_asu ();
  printf("ASU_out=%16llX\n", ASU_out);

}
