/*

f-cpu/ygasm/ygasm_malloc.c

This is a Free Software created : ven avr 28 21:08:06 CEST 2000 by Yann Guidon

This is a malloc() wrapper that tries to prevent memory fragmentation.
It does so by allocating memory with large fixed size chuncks.
This is a dumb version that does not manage memory block deallocation 
(free()) because the application does not need it. This simplifies things
in fact : it is "allocate and exit". It does not try to squeeze the last
bit of every block too.

Sun Jul 15 18:56:19 2001 : adaptation for ygasm
(this file was previously named MY_MALLOC.C)

*/

/*
#include <stdlib.h>
#include <stdio.h>
 should be already included by ygasm.h */


#define BLOCK_GRANULARITY 4096
char *current_block=NULL;
int block_size=BLOCK_GRANULARITY;

void * ygasm_malloc(int req_size) {
  char *p;

/* round up */
  req_size=(req_size+(sizeof(int*)-1))&(-sizeof(int*));

/* sanity check */
  if (req_size>BLOCK_GRANULARITY)
    ygasm_error("can't allocate memory : block is too large",NULL);

  if (block_size+req_size>BLOCK_GRANULARITY) {
    current_block=calloc(1,BLOCK_GRANULARITY);
    if (current_block==NULL)
      ygasm_error("can't allocate memory",NULL);
    block_size=req_size;
    return current_block;
  }

  /* else */
  p=&current_block[block_size];
  block_size+=req_size;
  return p;
}

/* nb : this is the "short" version of a more complex
   program that supported a "free" command. i hope that
   you don't fear memory leaks but who cares in the
   current case ? */
