#! /bin/sh
#  YG's script for compiling the F-CPU VHDL core
# with the command-line Vanilla VHDL.
# created Fri Sep  7 04:22:28 2001 by whygee@f-cpu.org
# version 

tool=mkvlib  # can be removed/replaced

# one-fits-all function
function vanilla ()
{
    echo ' - making '$1''
    if [ $static = "on" ]
      then 
	if ( va87 -x $1 ) | grep ERROR
	  then
	     echo 'OOOPS ! something went wrong...'
	     exit 1
        fi
      else
	if echo analyze -x $1 | vv87 | grep ERROR
	  then
	    echo 'OOOPS ! something went wrong...'
	    exit 1
	fi
    fi
}

function compile_vanilla ()
{
   if [ -e random ]
   then
     if [ ! -h random ]
     then
       echo ' ERROR ! the file named random is not a symlink !'
       exit 1
     fi
   else
     echo ' creating a symlink to the random special file'
     ln -s /dev/random random
   fi
   echo ' *** compiling the configuration packages'
   vanilla configuration/f-cpu_config.vhdl
   vanilla configuration/f-cpu_opcodes.vhdl
   vanilla configuration/clock_config.vhdl
   echo ' *** compiling the common packages'
   vanilla common/generic_adder.vhdl
   vanilla common/random.vhdl
   echo ' *** compiling the units ***'
   echo ' * compiling the clock unit (vanilla stripped-down version)'
   vanilla clock/clock_vanilla.vhdl
   echo ' * compiling the ASU'
   vanilla eu_asu/generic_adder.vhdl 
   vanilla eu_asu/iadd.vhdl
#   vanilla eu_asu/asu.vhdl
   echo ' * compiling the ROP2 unit'
   vanilla eu_rop2/rop2_xbar.vhdl
   vanilla eu_rop2/rop2_unit.vhdl
   
   echo ' *** compiling the top level ***'
   vanilla toplevel/toplevel.vhdl
   exit 0
}



# detect vanilla through locate :
if [ -z $(locate $tool) ]
then
    echo 'Vanilla VHDL is not detected : ciao'
    exit 1
else
    echo 'Vanilla VHDL mkvlib is detected in' $(locate $tool)
fi

#cleanup
if [ -d work ]
then
    echo 'removing work/'
    rm -R work
fi

# check if it works :
$tool 2> outmessage

if grep "Usage: mkvlib directory_name" outmessage > /dev/null
  then
    rm outmessage
    echo 'the dynamically linked version works !'
    static=on
    mkvlib work
    compile_vanilla
  else
    if grep "can't load library 'libc.so.5'" outmessage > /dev/null
      then
        rm outmessage
        echo 'the dynamically linked version failed ! i will try with the static version.'

        if echo | vv87 | grep "Vanilla Cad VHDL System"
	  then
	    static=off
	    echo 'i found the signature for the static version of Vanilla. cool !'
	    echo mkvlib work | vv87 | grep ERROR
	    echo ' ------------- making working directory -------------'
	    compile_vanilla
          else
	    echo ' ***** vv87 does not seem to work. adios.'
	    exit 1
          fi
      else
        rm outmessage
        echo $tool ' failed. adios !'
        exit 1
    fi
fi
