-- f-cpu/vhdl/common/rec_mux.vhdl : recursive multiplexer in VHDL'93
-- created  2001 by whygee
-- This file is copied and adapted from the book
-- "The designer's guide to VHDL" by Peter J. Ashenden.
-- I extended the model to a more suitable and general
-- version that allows a different fanout per buffer.
--
-- I have remarked that signal fanout can create problems,
-- particularly for such a short pipeline as the FC0.
-- If we don't take care during the design, a large fanout
-- that is not correctly spread can slow the whole circuit.
-- The ROP2 unit tries to do some efforts but other units
-- probably need this entity.
--
-- warning : use the correct generic parameters so the output
-- bus is exactly as wide as fanout**height ! otherwise you will
-- have some surprises ...

not finished yet !

library IEEE;
use IEEE.std_logic_1164.all;

entity fanout_tree is
  generic (
    height : natural;
    subsize : natural;
    fanout : natural);
  port (
    input  : in  std_logic;
    output : out std_logic_vector(0 to fanout**height - 1));
end fanout_tree;

architecture recursive of fanout_tree is
begin  -- recursive

  degenerate_tree: if height = 0 generate
  begin
    output <= (others => input);
  end generate degenerate_tree;

  compound_tree: if height > 0 generate
    signal buffered_input : std_logic_vector(fanout-1 downto 0);
  begin

--       buf : entity work.buf(basic)
--         port map (
--           a => input,
--           y => buffered_input(i);
--    The can be summarized as :
      buffered_input <= (others => input);

    fanout_loop: for i in 0 to fanout-1 generate
        variable b : natural := subsize * i;
      begin

      subtree : entity work.fanout_tree(recursive)
        generic map (
          height => height - 1,
          subsize => subsize / fanout,
          fanout => fanout)
        port map (
          input  => buffured_input(i),
          output => output(b to b+fanout-1);

    end generate fanout_loop;
  end generate compound_tree;
end recursive;
