-------------------------------------------------------------------------
-- WARNING !  This file is automatically generated !
-- compiled by USER = whygee on HOSTNAME = debian
-- DATE = Fri Sep  7 03:10:53 Local time zone must be set--see zic manual page 2001
-- PWD = /usr/yg/f-cpu/distro/f-cpu/configuration
-- Do not modify. Check all the m4 files in f-cpu/configuration
-- for the original definitions.
--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- source : f-cpu/configuration/f-cpu_config.vhdl.in
-- destination : f-cpu/vhdl/configuration/f-cpu_config.vhdl
-- (c) Yann GUIDON, oct. 21, 2000 <whygee@f-cpu.org>
--
-- v0.2 : Michael Riepe changed F_RANGE
-- v0.3 : YG specified the user-modifiable constants + GPL
-- v0.4 : MR proposed LOGMAXSIZE, YG added the ROP2 constants.
-- v0.5 : nov. 17, 2000, YG added SR_IRQ_BASE, SR_TRAP_BASE,
--         SR_SYSCALL_BASE, SR_URL etc.
-- v0.6 : nov. 26, 2000, YG moved some SR stuff to /VHDL/EU_sr
-- v0.7 : aug. 19, 2001, YG hacked for m4 preprocessing.
--        run f-cpu/configure.sh to update this file.
-- v0.8 : aug. 28, 2001 : YG + MR modified some stuffs.
--        MR hinted the "eval(radix)" trick, status is satisfying.
--
-- This package defines the "characteristic widths" of
-- the internal units. Please respect the restrictions.
--
-- **************************************************************
-- WARNING : All the user-modifiable values are defined in the 
-- f-cpu/configuration/f-cpu_user.m4 file.
-- **************************************************************
--
--  * LOGMAXSIZE : Log2 of the Size of the registers in bytes.
--  Can be any integer above or equal to 2. 2 corresponds to
--  a 32-bit implementation, 3 corresponds to a 64-bit version.
--  This is the most important parameter, the first with
--  which one can play. Be careful anyway. The 32-bit version will
--  not work yet.
--
--  * L1LogLines : Log2 of the NumBer of cache Lines (MUST be EVEN)
--  This parameter determines how many L1 cache lines are implemented.
--  It must be >=4 and _even_ because of the particular LRU mechanism
--  used for this prototype. Allowed values are 4, 6 or 8 (that is :
--  16, 64 or 256 lines, or 512 bytes, 2KB or 8KB). More would correspond
--  to a L2 cache... but are possible if you have enough ressources.
--
--  * L1ABwidth :Address Bus width, in 32-byte chuncks (32+5=128GB)
--  This determines the width of the address comparator of every L1
--  cache line. Be careful, too many bits might require a LOT of ressources.
--  A reasonable value for a small design would be 16 (2MB of adressable
--  physical memory), adapt as required. Warning : this parameter
--  also determines how many address bits are physically implemented.
--

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;

package FCPU_config is

------------------------------------------------------
-- Most important F-CPU constants :
------------------------------------------------------

-- Number >=2, 3 corresponds to 64-bit registers
  constant LOGMAXSIZE : natural := 3;
    -- defined in f-cpu/configuration/f-cpu_user.m4

-- Size of the registers in bytes
  constant MAXSIZE : natural := 2**LOGMAXSIZE;

-- Size of the registers in bits.
  constant UMAX : natural := MAXSIZE * 8;

-- Range of a register width declaration.
  subtype F_RANGE is natural range UMAX-1 downto 0 ;

-- shortcut for a very common declaration.
  subtype F_VECTOR is std_ulogic_vector(F_RANGE) ;

------------------------------------------------------
-- Some architectural constants, bound to FC0 only :
------------------------------------------------------

------------------------------------------------------
-- L1 Caches (split instructions and data)
------------------------------------------------------

-- Data Bus width, or width of each cache line (32 bytes)
  constant L1DBwidth  : natural := 256 ;

-- Address Bus width, in 32-byte chuncks (32+5=128GB)
  constant L1ABwidth  : natural := 32 ;

-- Log2 of the NumBer of cache Lines (MUST be EVEN)
-- (small number for the first attempts)
  constant L1LogLines : natural := 6 ;

-- NumBer of cache Lines (2**L1LogLines)
  constant L1NBlines  : natural := 2**L1LogLines ;

------------------------------------------------------
-- The Special Registers : (adapted from SR.h)
--
-- (please check f-cpu/configuration/f-cpu_sr.m4 !)
--
-- What the user should modify when implementing the core :
-- * SR_NUMBERS_val  should be updated when the
--     number of implemented SR changes.
-- * SR_FAMILY_val   specifies the type of core (FC0, FC1 etc).
--     This is meant to be used for selecting particular code
--     sections that are optimized for certain cores.
-- * SR_STEPPING_val specifies the mask revision, for example.
-- * SR_URL_val contains the Internet URL where the source, 
--     software and documentation are stored (64 char max.)
--
-- DO NOT MODIFY the other constants unless the specifications
-- change. New SRs will appear soon. Stay tuned.
------------------------------------------------------

-- number of SRs that are implemented in this model
  constant SR_NUMBERS      : natural := 0;
  constant SR_NUMBERS_val  : natural := 24;

-- F-CPU core number. remark : 0xFC0 = 4032d :-)
  constant SR_FAMILY       : natural := 1;
  constant SR_FAMILY_val   : natural := 4032;

-- revision/implementation
  constant SR_STEPPING     : natural := 2;
  constant SR_STEPPING_val : natural := 0;

-- in bytes, a power of two >= 3
  constant SR_MAX_SIZE     : natural := 3;
  constant SR_MAX_SIZE_val : natural := MAXSIZE;

-- Size attribute 0, hardwired if SR_MAX_SIZE <= 8
  constant SR_SIZE_0       : natural := 4;
  constant SR_SIZE_0_val   : natural := 1;

-- Size attribute 1, hardwired if SR_MAX_SIZE <= 8
  constant SR_SIZE_1       : natural := 5;
  constant SR_SIZE_1_val   : natural := 2;

-- Size attribute 2, hardwired if SR_MAX_SIZE <= 8
  constant SR_SIZE_2       : natural := 6;
  constant SR_SIZE_2_val   : natural := 4;

-- Size attribute 3, hardwired if SR_MAX_SIZE <= 8
  constant SR_SIZE_3       : natural := 7;
  constant SR_SIZE_3_val   : natural := 8;

-- R/W, Value is dynamic, incremented every cycle.
  constant SR_CYCLE        : natural := 8;

-- Protected, R/W, Controls the paged memory.
  constant SR_PAGING       : natural := 9;

-- IRQ, TRAP and SYSCALL jump tables : all are R/W in protected mode - only.
  constant SR_IRQ_BASE     : natural := 10;  -- For the hardware interrupt requests
  constant SR_IRQ_SIZE     : natural := 11;
  constant SR_TRAP_BASE    : natural := 12;  -- faults and system errors
  constant SR_TRAP_SIZE    : natural := 13;
  constant SR_SYSCALL_BASE : natural := 14;  -- OS system call
  constant SR_SYSCALL_SIZE : natural := 15;

-- The URL registers must be modified to point to the manual, sources, patches etc.
-- The registers are hardwired, format is ASCII and padded with 0s.
  constant SR_URL          : natural := 16;
-- 64 characters max. for a 64-bit version, 32 chars for a 32-bit version...
  constant SR_URL_size     : natural := 8;
  constant SR_URL_val      : string  := "http://www.f-cpu.org";
    -- defined in f-cpu/configuration/f-cpu_user.m4

-------------------------------------------------------
-- The ROP2 unit : these constants specify the
-- correspondance between the binary code and the actual
-- operation. These data are copied here for convenience
-- only, for example if you want to make an assembler in
-- VHDL. Check the file ROP2.vhdl for more informations.
--------------------------------------------------------

  constant ROP2_DIRECT_MODE : std_ulogic_vector(1 downto 0) := "00";
  constant ROP2_AND_MODE :    std_ulogic_vector(1 downto 0) := "01";
  constant ROP2_OR_MODE :     std_ulogic_vector(1 downto 0) := "10";
  constant ROP2_MUX_MODE :    std_ulogic_vector(1 downto 0) := "11";

  constant ROP2_AND   : std_ulogic_vector(2 downto 0) := "000";
  constant ROP2_ANDN  : std_ulogic_vector(2 downto 0) := "001";
  constant ROP2_XOR   : std_ulogic_vector(2 downto 0) := "010";
  constant ROP2_OR    : std_ulogic_vector(2 downto 0) := "011";
  constant ROP2_NOR   : std_ulogic_vector(2 downto 0) := "100";
  constant ROP2_XNOR  : std_ulogic_vector(2 downto 0) := "101";
  constant ROP2_ORN   : std_ulogic_vector(2 downto 0) := "110";
  constant ROP2_NAND  : std_ulogic_vector(2 downto 0) := "111";

  constant ROP2_VALUE_AND   : std_ulogic_vector(3 downto 0) := "0001";
  constant ROP2_VALUE_ANDN  : std_ulogic_vector(3 downto 0) := "0010";
  constant ROP2_VALUE_XOR   : std_ulogic_vector(3 downto 0) := "0110";
  constant ROP2_VALUE_OR    : std_ulogic_vector(3 downto 0) := "0111";
  constant ROP2_VALUE_NOR   : std_ulogic_vector(3 downto 0) := "1000";
  constant ROP2_VALUE_XNOR  : std_ulogic_vector(3 downto 0) := "1001";
  constant ROP2_VALUE_ORN   : std_ulogic_vector(3 downto 0) := "1011";
  constant ROP2_VALUE_NAND  : std_ulogic_vector(3 downto 0) := "1110";

end FCPU_config;


package body FCPU_config is

-- The use of the ilog functions is not recommended inside
-- the synthesisable processes, they are provided for
-- convenience only.

-- integer logarithm (rounded up) [MR version]
function ilog (x : natural; base : natural := 2) return natural is
  variable y : natural := 1;
begin
  while x > base ** y loop
    y := y + 1;
  end loop;
  return y;
end ilog;

-- integer logarithm (rounded up) [YG version]
-- i wonder if there is an off-by-1 error... ?
function ilog2 (x : natural) return natural is
  variable y : natural := 1;
  variable z : natural := 1;
begin
  while x > z loop
    y := y + 1;
    z := z + z;  -- you can notice the "little" enhancement :o)
  end loop;
  return y;
end ilog2;

------------------------------------------------------
-- Some useful wrappers or functions could be included
-- here if they are necessary for rest of the project.
------------------------------------------------------

end FCPU_config;
