--------------------------BEGIN-VHDL-LICENCE-----------------------------
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
---------------------------END-VHDL-LICENCE------------------------------
--
-- f-cpu/vhdl/clock/clock_simple.vhdl, behavioural clock generator for the FC0
-- created Wed Sep  5 04:35:14 2001 by Yann GUIDON <whygee@f-cpu.org>
-- version Fri Sep  7 09:01:17 
-- version sam dec 15 23:30:14 GMT 2001 : simple behavioural entity
--
-- This is a nice little behavioural entity which should do the power-on
-- sequence nicely.

LIBRARY ieee;
    USE ieee.std_logic_1164.ALL;
    USE ieee.numeric_std.all;
LIBRARY work;
    USE work.clock_config.ALL;
    USE work.clock;

-------------------------------------------------------------------------------
-- stand-alone behavioural clock with power-on sequence :
-- clock_in is ignored but reset_in is used.
-------------------------------------------------------------------------------
Architecture simple of clock is
  signal clk, clk_en : std_ulogic;
begin
  
-------------------------------------------------------------------------------
-- the main sequence
-------------------------------------------------------------------------------
  process
  begin
    -- master init
    clock_out <= '0';
    clock_ok <= '0';
    clk_en <= '0';

    -- power supply setup
    wait for 1 us;

    -- start the clock
    clk_en <= '1';

    wait for 1 us;
    
    -- allow the core to boot
    clock_ok <= '1';

    wait;
  end;

-----------------------------------------------------------------------------
-- the clock process which is enabled by clk_en
-----------------------------------------------------------------------------
  process
  begin
    wait until clk_en = '1';
    clk <= not clk;
    clock_out <= clk;
    wait for 10 ns;
  end;

end;
