/*

f-cpu/qdcpoc2/main.c
created Wed Jul 11 01:23:48 2001 by whygee@f-cpu.org

Beware ! don't do what is written here at home !
Don't let children look, or they'll be scared to death !

(C) YG all rights reserved. you're warned !!!
read f-cpu/qdcpoc/about.txt for the details.

version : Sat Aug 11 02:11:55 2001

*/

/* include all the usual libs */
#include "qdcpoc2.h"


/* pretty printing, useful inside GDB */
void lli(UMAX i) {
  printf("%016llX\n",i);
}


void qdcpoc_error(char * message, int n) {
  fprintf(stderr, "\nError : %s\7\n", message);
  exit(n);
} /* never returns... */


/* now we include all the functions : */
#include "fetcher.c"
#include "register_set.c"
#include "rop2.c"
#include "xbar.c"
/* the other units come here */
#include "bist.c" /* needs the fc0_cycle_xxx() of each tested unit */
#include "init.c" /* calls the BIST_xxx() routines */


void fc0_cycle() {
/*
    This is a second version that changes from the first qdcpoc.
    This function executes the codes and then "connects" the units
    together. The FF are thus simulated and the naming conventions
    will be conserved in the VHDL code. The ordering is not
    important now but you have to read the FC0 documentation
    even more carefully. Particularly, look at f-cpu/FC0-diagram.ps
    to see all the connexions and the names on one page.
*/

  fc0_cycle_fetcher();        /* fetcher.c */
  fc0_cycle_register_set();   /* register_set.c */
  fc0_cycle_Xbar();           /* xbar.c */
  fc0_cycle_ROP2();           /* rop2.c */
  fc0_cycle_BIST();           /* bist.c */

  /* more units will be added here */

  /* now, connect the units together : */

  /* fetcher -> register set */
  R7_read_address_2 = instruction_buffer & 63;
  R7_read_address_1 = (instruction_buffer >> 6) & 63;
  R7_read_address_0 = (instruction_buffer >> 12) & 63;

  /* fetcher -> Xbar (delay is omitted :-/) */
  Xbar_read_CIP = FETCH_VIP;

  /* register set -> Xbar */
  Xbar_R7_read_port_0 = R7_read_port_0;
  Xbar_R7_read_port_1 = R7_read_port_1;
  Xbar_R7_read_port_2 = R7_read_port_2;

  /* register set -> Xbar */
  R7_write_port_0 = Xbar_read_port_0;
  R7_write_port_1 = Xbar_read_port_1;

}


int main(int argc, char **argv) {

  if (argc <= 1)
    qdcpoc_error("need 1 arg : please give the input filename !", 5);

  elaborate_opcode_LUT();
  init_fc0();
  init_fetcher(argv[1]);

  fetch_next_instruction = 1; /* force the fetch */
  do {
    fc0_cycle();
  } while (1);

  return 0;
}
